// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.style;

import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import net.sourceforge.plantuml.skin.SkinParam;
import net.sourceforge.plantuml.utils.Log;

public class StyleBuilder implements AutomaticCounter {
    // ::remove file when __HAXE__

	private final Map<StyleSignatureBasic, Style> stylesMap = new LinkedHashMap<StyleSignatureBasic, Style>();
	private final Set<StyleSignatureBasic> printedForLog;
	private final SkinParam skinParam;
	private int counter;

	public void printMe() {
		for (Entry<StyleSignatureBasic, Style> ent : stylesMap.entrySet())
			ent.getValue().printMe();

	}

	private StyleBuilder(SkinParam skinParam, Set<StyleSignatureBasic> printedForLog) {
		this.skinParam = skinParam;
		this.printedForLog = new LinkedHashSet<>();
	}

	public StyleBuilder(SkinParam skinParam) {
		this(skinParam, new LinkedHashSet<StyleSignatureBasic>());
	}

	public final SkinParam getSkinParam() {
		return skinParam;
	}

	public Style createStyle(String name) {
		if (name.contains(StyleSignatureBasic.STAR))
			throw new IllegalArgumentException();

		name = name.toLowerCase();
		final StyleSignatureBasic signature = new StyleSignatureBasic(name);
		final Style result = stylesMap.get(signature);
		if (result == null)
			return new Style(signature, new EnumMap<PName, Value>(PName.class));

		return result;
	}

	public StyleBuilder muteStyle(Style modifiedStyle) {
		final Map<StyleSignatureBasic, Style> copy = new LinkedHashMap<StyleSignatureBasic, Style>(stylesMap);
		final StyleSignatureBasic signature = modifiedStyle.getSignature();
		final Style orig = copy.get(signature);
		if (orig == null) {
			copy.put(signature, modifiedStyle);
		} else {
			final Style tmp = orig.mergeWith(modifiedStyle, MergeStrategy.OVERWRITE_EXISTING_VALUE);
			copy.put(signature, tmp);
		}
		final StyleBuilder result = new StyleBuilder(skinParam, this.printedForLog);
		result.stylesMap.putAll(copy);
		result.counter = this.counter;
		return result;
	}

	public void loadInternal(StyleSignatureBasic signature, Style newStyle) {
		if (signature.isStarred())
			throw new IllegalArgumentException();

		final Style orig = this.stylesMap.get(signature);
		if (orig == null) {
			this.stylesMap.put(signature, newStyle);
		} else {
			final Style tmp = orig.mergeWith(newStyle, MergeStrategy.OVERWRITE_EXISTING_VALUE);
			this.stylesMap.put(signature, tmp);
		}
	}

	public int getNextInt() {
		return ++counter;
	}

	public Style getMergedStyle(StyleSignatureBasic signature) {
		boolean added = this.printedForLog.add(signature);
		if (added)
			Log.info("Using style " + signature);

		Style result = null;
		for (Entry<StyleSignatureBasic, Style> ent : stylesMap.entrySet()) {
			final StyleSignatureBasic key = ent.getKey();
			if (key.matchAll(signature) == false)
				continue;

			if (result == null)
				result = ent.getValue();
			else
				result = result.mergeWith(ent.getValue(), MergeStrategy.OVERWRITE_EXISTING_VALUE);

		}
		return result;
	}

	public Style getMergedStyleSpecial(StyleSignatureBasic signature, int deltaPriority) {
		boolean added = this.printedForLog.add(signature);
		if (added)
			Log.info("Using style " + signature);

		Style result = null;
		for (Entry<StyleSignatureBasic, Style> ent : stylesMap.entrySet()) {
			final StyleSignatureBasic key = ent.getKey();
			if (key.matchAll(signature) == false)
				continue;

			Style tmp = ent.getValue();
			if (key.isStarred())
				tmp = tmp.deltaPriority(deltaPriority);

			if (result == null)
				result = tmp;
			else
				result = result.mergeWith(tmp, MergeStrategy.OVERWRITE_EXISTING_VALUE);

		}
		return result;
	}

}
