// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.json;

/**
 * A handler for parser events. Instances of this class can be given to a
 * {@link JsonParser}. The parser will then call the methods of the given
 * handler while reading the input.
 * <p>
 * The default implementations of these methods do nothing. Subclasses may
 * override only those methods they are interested in. They can use
 * <code>getLocation()</code> to access the current character position of the
 * parser at any point. The <code>start*</code> methods will be called while the
 * location points to the first character of the parsed element. The
 * <code>end*</code> methods will be called while the location points to the
 * character position that directly follows the last character of the parsed
 * element. Example:
 * </p>
 *
 * <pre>
 * ["lorem ipsum"]
 *  ^            ^
 *  startString  endString
 * </pre>
 * <p>
 * Subclasses that build an object representation of the parsed JSON can return
 * arbitrary handler objects for JSON arrays and JSON objects in
 * {@link #startArray()} and {@link #startObject()}. These handler objects will
 * then be provided in all subsequent parser events for this particular array or
 * object. They can be used to keep track the elements of a JSON array or
 * object.
 * </p>
 *
 * @param <A> The type of handlers used for JSON arrays
 * @param <O> The type of handlers used for JSON objects
 * @see JsonParser
 */
public abstract class JsonHandler<A, O> {
    // ::remove folder when __HAXE__

	JsonParser parser;

	/**
	 * Returns the current parser location.
	 *
	 * @return the current parser location
	 */
	protected Location getLocation() {
		return parser.getLocation();
	}

	/**
	 * Indicates the beginning of a <code>null</code> literal in the JSON input.
	 * This method will be called when reading the first character of the literal.
	 */
	public void startNull() {
	}

	/**
	 * Indicates the end of a <code>null</code> literal in the JSON input. This
	 * method will be called after reading the last character of the literal.
	 */
	public void endNull() {
	}

	/**
	 * Indicates the beginning of a boolean literal (<code>true</code> or
	 * <code>false</code>) in the JSON input. This method will be called when
	 * reading the first character of the literal.
	 */
	public void startBoolean() {
	}

	/**
	 * Indicates the end of a boolean literal (<code>true</code> or
	 * <code>false</code>) in the JSON input. This method will be called after
	 * reading the last character of the literal.
	 *
	 * @param value the parsed boolean value
	 */
	public void endBoolean(boolean value) {
	}

	/**
	 * Indicates the beginning of a string in the JSON input. This method will be
	 * called when reading the opening double quote character
	 * (<code>'&quot;'</code>).
	 */
	public void startString() {
	}

	/**
	 * Indicates the end of a string in the JSON input. This method will be called
	 * after reading the closing double quote character (<code>'&quot;'</code>).
	 *
	 * @param string the parsed string
	 */
	public void endString(String string) {
	}

	/**
	 * Indicates the beginning of a number in the JSON input. This method will be
	 * called when reading the first character of the number.
	 */
	public void startNumber() {
	}

	/**
	 * Indicates the end of a number in the JSON input. This method will be called
	 * after reading the last character of the number.
	 *
	 * @param string the parsed number string
	 */
	public void endNumber(String string) {
	}

	/**
	 * Indicates the beginning of an array in the JSON input. This method will be
	 * called when reading the opening square bracket character (<code>'['</code>).
	 * <p>
	 * This method may return an object to handle subsequent parser events for this
	 * array. This array handler will then be provided in all calls to
	 * {@link #startArrayValue(Object) startArrayValue()},
	 * {@link #endArrayValue(Object) endArrayValue()}, and {@link #endArray(Object)
	 * endArray()} for this array.
	 * </p>
	 *
	 * @return a handler for this array, or <code>null</code> if not needed
	 */
	public A startArray() {
		return null;
	}

	/**
	 * Indicates the end of an array in the JSON input. This method will be called
	 * after reading the closing square bracket character (<code>']'</code>).
	 *
	 * @param array the array handler returned from {@link #startArray()}, or
	 *              <code>null</code> if not provided
	 */
	public void endArray(A array) {
	}

	/**
	 * Indicates the beginning of an array element in the JSON input. This method
	 * will be called when reading the first character of the element, just before
	 * the call to the <code>start</code> method for the specific element type
	 * ({@link #startString()}, {@link #startNumber()}, etc.).
	 *
	 * @param array the array handler returned from {@link #startArray()}, or
	 *              <code>null</code> if not provided
	 */
	public void startArrayValue(A array) {
	}

	/**
	 * Indicates the end of an array element in the JSON input. This method will be
	 * called after reading the last character of the element value, just after the
	 * <code>end</code> method for the specific element type (like
	 * {@link #endString(String) endString()}, {@link #endNumber(String)
	 * endNumber()}, etc.).
	 *
	 * @param array the array handler returned from {@link #startArray()}, or
	 *              <code>null</code> if not provided
	 */
	public void endArrayValue(A array) {
	}

	/**
	 * Indicates the beginning of an object in the JSON input. This method will be
	 * called when reading the opening curly bracket character (<code>'{'</code>).
	 * <p>
	 * This method may return an object to handle subsequent parser events for this
	 * object. This object handler will be provided in all calls to
	 * {@link #startObjectName(Object) startObjectName()},
	 * {@link #endObjectName(Object, String) endObjectName()},
	 * {@link #startObjectValue(Object, String) startObjectValue()},
	 * {@link #endObjectValue(Object, String) endObjectValue()}, and
	 * {@link #endObject(Object) endObject()} for this object.
	 * </p>
	 *
	 * @return a handler for this object, or <code>null</code> if not needed
	 */
	public O startObject() {
		return null;
	}

	/**
	 * Indicates the end of an object in the JSON input. This method will be called
	 * after reading the closing curly bracket character (<code>'}'</code>).
	 *
	 * @param object the object handler returned from {@link #startObject()}, or
	 *               null if not provided
	 */
	public void endObject(O object) {
	}

	/**
	 * Indicates the beginning of the name of an object member in the JSON input.
	 * This method will be called when reading the opening quote character
	 * ('&quot;') of the member name.
	 *
	 * @param object the object handler returned from {@link #startObject()}, or
	 *               <code>null</code> if not provided
	 */
	public void startObjectName(O object) {
	}

	/**
	 * Indicates the end of an object member name in the JSON input. This method
	 * will be called after reading the closing quote character (<code>'"'</code>)
	 * of the member name.
	 *
	 * @param object the object handler returned from {@link #startObject()}, or
	 *               null if not provided
	 * @param name   the parsed member name
	 */
	public void endObjectName(O object, String name) {
	}

	/**
	 * Indicates the beginning of the name of an object member in the JSON input.
	 * This method will be called when reading the opening quote character
	 * ('&quot;') of the member name.
	 *
	 * @param object the object handler returned from {@link #startObject()}, or
	 *               <code>null</code> if not provided
	 * @param name   the member name
	 */
	public void startObjectValue(O object, String name) {
	}

	/**
	 * Indicates the end of an object member value in the JSON input. This method
	 * will be called after reading the last character of the member value, just
	 * after the <code>end</code> method for the specific member type (like
	 * {@link #endString(String) endString()}, {@link #endNumber(String)
	 * endNumber()}, etc.).
	 *
	 * @param object the object handler returned from {@link #startObject()}, or
	 *               null if not provided
	 * @param name   the parsed member name
	 */
	public void endObjectValue(O object, String name) {
	}

}
