// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.code.deflate;

/* 
 * Simple DEFLATE decompressor
 * Copyright (c) Project Nayuki
 * 
 * https://www.nayuki.io/page/simple-deflate-decompressor
 * https://github.com/nayuki/Simple-DEFLATE-decompressor
 */

import java.io.IOException;
import java.util.Objects;

/**
 * Stores a finite recent history of a byte stream. Useful as an implicit
 * dictionary for Lempel-Ziv schemes. Mutable and not thread-safe.
 */
final class ByteHistory {

	/*---- Fields ----*/

	// Circular buffer of byte data.
	private byte[] data;

	// Index of next byte to write to, always in the range [0, data.length).
	private int index;

	/*---- Constructor ----*/

	/**
	 * Constructs a byte history of the specified size, initialized to zeros.
	 * 
	 * @param size the size, which must be positive
	 * @throws IllegalArgumentException if size is zero or negative
	 */
	public ByteHistory(int size) {
		if (size < 1)
			throw new IllegalArgumentException("Size must be positive");
		data = new byte[size];
		index = 0;
	}

	/*---- Methods ----*/

	/**
	 * Appends the specified byte to this history. This overwrites the byte value at
	 * {@code size} positions ago.
	 * 
	 * @param b the byte value to append
	 */
	public void append(int b) {
		if (index < 0 || index >= data.length)
			throw new IllegalStateException();
		data[index] = (byte) b;
		index = (index + 1) % data.length;
	}

	/**
	 * Copies {@code len} bytes starting at {@code dist} bytes ago to the specified
	 * output stream and also back into this buffer itself.
	 * <p>
	 * Note that if the length exceeds the distance, then some of the output data
	 * will be a copy of data that was copied earlier in the process.
	 * </p>
	 * 
	 * @param dist the distance to go back, in the range [1, size]
	 * @param len  the length to copy, which must be at least 0
	 * @param out  the output stream to write to (not {@code null})
	 * @throws NullPointerException     if the output stream is {@code null}
	 * @throws IllegalArgumentException if the length is negative, distance is not
	 *                                  positive, or distance is greater than the
	 *                                  buffer size
	 * @throws IOException              if an I/O exception occurs
	 */
	public void copy(int dist, int len, OutputStreamProtected out) throws IOException {
		Objects.requireNonNull(out);
		if (len < 0 || dist < 1 || dist > data.length)
			throw new IllegalArgumentException();

		int readIndex = (index - dist + data.length) % data.length;
		if (readIndex < 0 || readIndex >= data.length)
			throw new IllegalStateException();

		for (int i = 0; i < len; i++) {
			byte b = data[readIndex];
			readIndex = (readIndex + 1) % data.length;
			out.write(b);
			append(b);
		}
	}

}
