// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.plot;

import jcckit.data.DataPlot;
import jcckit.graphic.Anchor;
import jcckit.graphic.ClippingRectangle;
import jcckit.util.ConfigParameters;

/**
 * An abstract canvas containg a single {@link Plot}. The canvas is specified
 * by a {@link ClippingRectangle}, called <em>paper</em>. A horizontal and
 * vertical {@link Anchor} determine the position of the paper on the actual
 * device.
 * 
 * @author Franz-Josef Elmer
 */
public class PlotCanvas implements PlotListener {
	/** Configuration parameter key. */
	public static final String PAPER_KEY = "paper", HORIZONTAL_ANCHOR_KEY = "horizontalAnchor",
			VERTICAL_ANCHOR_KEY = "verticalAnchor", PLOT_KEY = "plot";
	private final ClippingRectangle _paper;
	private final Anchor _horizontalAnchor;
	private final Anchor _verticalAnchor;
	private final Plot _plot;

	/**
	 * Creates an instance from the specified configuration parameters. <table
	 * border=1 cellpadding=5>
	 * <tr>
	 * <th>Key &amp; Default Value</th>
	 * <th>Type</th>
	 * <th>Mandatory</th>
	 * <th>Description</th>
	 * </tr>
	 * <tr>
	 * <td><tt>horizontalAnchor = center</tt></td>
	 * <td><tt>String</tt></td>
	 * <td>no</td>
	 * <td>Horizontal position of the paper relative to the device border.
	 * Possible values are <tt>left</tt>, <tt>center</tt>, and
	 * <tt>right</tt>.</td>
	 * </tr>
	 * <tr>
	 * <td><tt>paper = 0,&nbsp;0,&nbsp;1,&nbsp;0.6</tt></td>
	 * <td><tt>double[]</tt></td>
	 * <td>no</td>
	 * <td>Rectangle defining the paper. The first two values determine the x-
	 * and y- coordinates (in device-independent units) of the lower-left
	 * corner. The last two values determine the upper-right corner.</td>
	 * </tr>
	 * <tr>
	 * <td><tt>plot = </tt>default values of {@link Plot}</td>
	 * <td><tt>ConfigParameters</tt></td>
	 * <td>no</td>
	 * <td>Definition of the {@link Plot}.</td>
	 * </tr>
	 * <tr>
	 * <td><tt>verticalAnchor = center</tt></td>
	 * <td><tt>String</tt></td>
	 * <td>no</td>
	 * <td>Vertical position of the paper relative to the device border.
	 * Possible values are <tt>top</tt>, <tt>center</tt>, and
	 * <tt>bottom</tt>.</td>
	 * </tr>
	 * </table>
	 * <p>
	 * Note, that this instance registers itself at the wrapped {@link Plot}
	 * instance.
	 */
	public PlotCanvas(ConfigParameters config) {
		double[] paper = config.getDoubleArray(PAPER_KEY, new double[] { 0, 0, 1, 0.6 });
		_paper = new ClippingRectangle(paper[0], paper[1], paper[2], paper[3]);
		_horizontalAnchor = Anchor.getHorizontalAnchor(config, HORIZONTAL_ANCHOR_KEY, Anchor.CENTER);
		_verticalAnchor = Anchor.getVerticalAnchor(config, VERTICAL_ANCHOR_KEY, Anchor.CENTER);
		_plot = new Plot(config.getNode(PLOT_KEY));
		_plot.addPlotListener(this);
	}

	/** Returns the paper definition. */
	public ClippingRectangle getPaper() {
		return _paper;
	}

	/** Returns the horizontal anchor. */
	public Anchor getHorizontalAnchor() {
		return _horizontalAnchor;
	}

	/** Returns the vertical anchor. */
	public Anchor getVerticalAnchor() {
		return _verticalAnchor;
	}

	/** Returns the plot. */
	public Plot getPlot() {
		return _plot;
	}

	/**
	 * Connects the wrapped {@link Plot} instance with the specified
	 * {@link DataPlot}.
	 * 
	 * @param dataPlot
	 *            Data to be connected with this plot canvas. Can be
	 *            <tt>null</tt> in order to disconnect this instance from a
	 *            <tt>DataPlot</tt>.
	 */
	public void connect(DataPlot dataPlot) {
		_plot.connect(dataPlot);
	}

	/**
	 * Handles the spcified event. Here nothing is done. But subclass may
	 * override this method.
	 */
	public void plotChanged(PlotEvent event) {
	}
}
