/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.abel.CucaNote;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityPosition;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.abel.Together;
import net.sourceforge.plantuml.cucadiagram.ICucaDiagram;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.decoration.symbol.USymbols;
import net.sourceforge.plantuml.dot.GraphvizVersion;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.MagneticBorder;
import net.sourceforge.plantuml.klimt.geom.MagneticBorderNone;
import net.sourceforge.plantuml.klimt.geom.Moveable;
import net.sourceforge.plantuml.klimt.geom.RectangleArea;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UComment;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.skin.AlignmentParam;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.ClusterDecoration;
import net.sourceforge.plantuml.svek.ClusterDotString;
import net.sourceforge.plantuml.svek.ClusterHeader;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.FrontierCalculator;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.svek.RoundedContainer;
import net.sourceforge.plantuml.svek.SvekEdge;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.image.EntityImageNoteLink;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.svek.image.EntityImageStateCommon;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.utils.Position;

public class Cluster
implements Moveable {
    static final String RANK_SOURCE = "source";
    static final String RANK_SINK = "sink";
    public static final String CENTER_ID = "za";
    private final Cluster parentCluster;
    private final Entity group;
    private final List<SvekNode> nodes = new ArrayList<SvekNode>();
    private final List<Cluster> children = new ArrayList<Cluster>();
    private final int color;
    private final int colorTitle;
    private final int colorNoteTop;
    private final int colorNoteBottom;
    private final ISkinParam skinParam;
    protected final ICucaDiagram diagram;
    private ClusterHeader clusterHeader;
    private XPoint2D xyTitle;
    private XPoint2D xyNoteTop;
    private XPoint2D xyNoteBottom;
    private RectangleArea rectangleArea;
    private int togetherCounter = 0;

    @Override
    public void moveDelta(double deltaX, double deltaY) {
        if (this.xyNoteTop != null) {
            this.xyNoteTop = this.xyNoteTop.move(deltaX, deltaY);
        }
        if (this.xyNoteBottom != null) {
            this.xyNoteBottom = this.xyNoteBottom.move(deltaX, deltaY);
        }
        if (this.xyTitle != null) {
            this.xyTitle = this.xyTitle.move(deltaX, deltaY);
        }
        if (this.rectangleArea != null) {
            this.rectangleArea = this.rectangleArea.move(deltaX, deltaY);
        }
    }

    private Set<EntityPosition> entityPositionsExceptNormal() {
        EnumSet<EntityPosition> result = EnumSet.noneOf(EntityPosition.class);
        for (SvekNode sh : this.nodes) {
            if (sh.getEntityPosition() == EntityPosition.NORMAL) continue;
            result.add(sh.getEntityPosition());
        }
        return Collections.unmodifiableSet(result);
    }

    public Cluster(ICucaDiagram diagram, ColorSequence colorSequence, ISkinParam skinParam, Entity root) {
        this(diagram, null, colorSequence, skinParam, root);
    }

    private Cluster(ICucaDiagram diagram, Cluster parentCluster, ColorSequence colorSequence, ISkinParam skinParam, Entity group) {
        if (group == null) {
            throw new IllegalStateException();
        }
        this.parentCluster = parentCluster;
        this.group = group;
        this.diagram = diagram;
        this.color = colorSequence.getValue();
        this.colorTitle = colorSequence.getValue();
        this.colorNoteTop = colorSequence.getValue();
        this.colorNoteBottom = colorSequence.getValue();
        this.skinParam = group.getColors().mute(skinParam);
    }

    public String toString() {
        return super.toString() + " " + this.group;
    }

    public final Cluster getParentCluster() {
        return this.parentCluster;
    }

    public void addNode(SvekNode node) {
        this.nodes.add(Objects.requireNonNull(node));
        node.setCluster(this);
    }

    public final List<SvekNode> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public final List<SvekNode> getNodes(EnumSet<EntityPosition> position) {
        ArrayList<SvekNode> result = new ArrayList<SvekNode>();
        for (SvekNode node : this.nodes) {
            if (!position.contains((Object)node.getEntityPosition())) continue;
            result.add(node);
        }
        return Collections.unmodifiableList(result);
    }

    private List<SvekNode> getNodesOrderedTop(Collection<SvekEdge> lines) {
        ArrayList<SvekNode> firsts = new ArrayList<SvekNode>();
        HashMap<String, SvekNode> shs = new HashMap<String, SvekNode>();
        for (SvekNode node : this.nodes) {
            shs.put(node.getUid(), node);
        }
        for (SvekEdge l : lines) {
            SvekNode sh;
            if (!l.isInverted() || (sh = (SvekNode)shs.get(l.getStartUidPrefix())) == null || !this.isNormalPosition(sh)) continue;
            firsts.add(0, sh);
        }
        return firsts;
    }

    private boolean isNormalPosition(SvekNode sh) {
        return sh.getEntityPosition() == EntityPosition.NORMAL;
    }

    private List<SvekNode> getNodesOrderedWithoutTop(Collection<SvekEdge> lines) {
        ArrayList<SvekNode> all = new ArrayList<SvekNode>(this.nodes);
        HashMap<String, SvekNode> shs = new HashMap<String, SvekNode>();
        Iterator it = all.iterator();
        while (it.hasNext()) {
            SvekNode sh = (SvekNode)it.next();
            if (!this.isNormalPosition(sh)) {
                it.remove();
                continue;
            }
            shs.put(sh.getUid(), sh);
        }
        for (SvekEdge l : lines) {
            SvekNode sh;
            if (!l.isInverted() || (sh = (SvekNode)shs.get(l.getStartUidPrefix())) == null) continue;
            all.remove(sh);
        }
        return all;
    }

    public final List<Cluster> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Cluster createChild(ClusterHeader clusterHeader, ColorSequence colorSequence, ISkinParam skinParam, Entity g) {
        Cluster child = new Cluster(this.diagram, this, colorSequence, skinParam, g);
        child.clusterHeader = clusterHeader;
        this.children.add(child);
        return child;
    }

    public final Set<Entity> getGroups() {
        return Collections.singleton(this.group);
    }

    final Entity getGroup() {
        return this.group;
    }

    public final int getTitleAndAttributeWidth() {
        return this.clusterHeader.getTitleAndAttributeWidth();
    }

    public final int getTitleAndAttributeHeight() {
        return this.clusterHeader.getTitleAndAttributeHeight();
    }

    public RectangleArea getRectangleArea() {
        return this.rectangleArea;
    }

    public void setTitlePosition(XPoint2D pos) {
        this.xyTitle = pos;
    }

    public void setNoteTopPosition(XPoint2D pos) {
        this.xyNoteTop = pos;
    }

    public void setNoteBottomPosition(XPoint2D pos) {
        this.xyNoteBottom = pos;
    }

    public static StyleSignatureBasic getDefaultStyleDefinition(SName diagramStyleName, USymbol symbol, GroupType groupType) {
        if (diagramStyleName == SName.stateDiagram) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state, SName.group);
        }
        if (symbol != null) {
            return StyleSignatureBasic.of(SName.root, SName.element, diagramStyleName, SName.group, symbol.getSName());
        }
        if (groupType == GroupType.PACKAGE) {
            return StyleSignatureBasic.of(SName.root, SName.element, diagramStyleName, SName.package_, SName.group);
        }
        return StyleSignatureBasic.of(SName.root, SName.element, diagramStyleName, SName.group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawU(UGraphic ug, UmlDiagramType umlDiagramType) {
        String fullName;
        if (this.group.isHidden()) {
            return;
        }
        if (this.diagram.getPragma().useKermor()) {
            if (this.xyNoteTop != null) {
                this.getCucaNote(Position.TOP).drawU(ug.apply(UTranslate.point(this.xyNoteTop)));
            }
            if (this.xyNoteBottom != null) {
                this.getCucaNote(Position.BOTTOM).drawU(ug.apply(UTranslate.point(this.xyNoteBottom)));
            }
        }
        if (!(fullName = this.group.getName()).startsWith("##")) {
            ug.draw(new UComment("cluster " + fullName));
        }
        USymbol uSymbol = this.group.getUSymbol() == null ? USymbols.PACKAGE : this.group.getUSymbol();
        Style style = Cluster.getDefaultStyleDefinition(umlDiagramType.getStyleName(), uSymbol, this.group.getGroupType()).withTOBECHANGED(this.group.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        double shadowing = style.value(PName.Shadowing).asDouble();
        HColor borderColor = this.group.getColors().getColor(ColorType.LINE) != null ? this.group.getColors().getColor(ColorType.LINE) : style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        double rounded = style.value(PName.RoundCorner).asDouble();
        if (this.skinParam.strictUmlStyle()) {
            rounded = 0.0;
        }
        double diagonalCorner = style.value(PName.DiagonalCorner).asDouble();
        ug.startGroup(Collections.singletonMap(UGroupType.ID, "cluster_" + fullName));
        Url url = this.group.getUrl99();
        if (url != null) {
            ug.startUrl(url);
        }
        try {
            boolean isState;
            if (this.entityPositionsExceptNormal().size() > 0) {
                this.manageEntryExitPoint(ug.getStringBounder());
            }
            if (this.skinParam.useSwimlanes(umlDiagramType)) {
                this.drawSwinLinesState(ug, borderColor);
                return;
            }
            boolean bl = isState = umlDiagramType == UmlDiagramType.STATE;
            if (isState && this.group.getUSymbol() == null) {
                this.drawUState(ug, umlDiagramType, rounded, shadowing);
                return;
            }
            PackageStyle packageStyle = this.group.getPackageStyle();
            if (packageStyle == null) {
                packageStyle = this.skinParam.packageStyle();
            }
            UStroke stroke = Cluster.getStrokeInternal(this.group, style);
            HColor backColor = this.getBackColor(umlDiagramType, style);
            backColor = Cluster.getBackColor(backColor, this.group.getStereotype(), umlDiagramType.getStyleName(), this.group.getUSymbol(), this.skinParam.getCurrentStyleBuilder(), this.skinParam.getIHtmlColorSet(), this.group.getGroupType());
            ClusterDecoration decoration = new ClusterDecoration(packageStyle, this.group.getUSymbol(), this.clusterHeader.getTitle(), this.clusterHeader.getStereo(), this.rectangleArea, stroke);
            decoration.drawU(ug, backColor, borderColor, shadowing, rounded, this.skinParam.getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null), this.skinParam.getStereotypeAlignment(), diagonalCorner);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (url != null) {
                ug.closeUrl();
            }
            ug.closeGroup();
        }
    }

    EntityImageNoteLink getCucaNote(Position position) {
        List<CucaNote> notes = this.getGroup().getNotes(position);
        if (notes.size() == 0) {
            return null;
        }
        CucaNote note = notes.get(0);
        return new EntityImageNoteLink(note.getDisplay(), note.getColors(), this.skinParam, this.skinParam.getCurrentStyleBuilder());
    }

    public static UStroke getStrokeInternal(Entity group, Style style) {
        Colors colors = group.getColors();
        if (colors.getSpecificLineStroke() != null) {
            return colors.getSpecificLineStroke();
        }
        return style.getStroke();
    }

    void manageEntryExitPoint(StringBounder stringBounder) {
        ArrayList<RectangleArea> insides = new ArrayList<RectangleArea>();
        ArrayList<XPoint2D> points = new ArrayList<XPoint2D>();
        for (SvekNode sh : this.nodes) {
            if (this.isNormalPosition(sh)) {
                insides.add(sh.getRectangleArea());
                continue;
            }
            points.add(sh.getRectangleArea().getPointCenter());
        }
        for (Cluster in : this.children) {
            if (in.getRectangleArea() == null) {
                System.err.println("Frontier null for " + in);
                continue;
            }
            insides.add(in.getRectangleArea());
        }
        FrontierCalculator frontierCalculator = new FrontierCalculator(this.getRectangleArea(), insides, points, this.skinParam.getRankdir());
        if (this.getTitleAndAttributeWidth() > 0 && this.getTitleAndAttributeHeight() > 0) {
            frontierCalculator.ensureMinWidth(this.getTitleAndAttributeWidth() + 10);
        }
        this.rectangleArea = frontierCalculator.getSuggestedPosition();
        double widthTitle = this.clusterHeader.getTitle().calculateDimension(stringBounder).getWidth();
        double minX = this.rectangleArea.getMinX();
        double minY = this.rectangleArea.getMinY();
        this.xyTitle = new XPoint2D(minX + (this.rectangleArea.getWidth() - widthTitle) / 2.0, minY + 5.0);
    }

    private void drawSwinLinesState(UGraphic ug, HColor borderColor) {
        this.clusterHeader.getTitle().drawU(ug.apply(UTranslate.dx(this.xyTitle.x)));
        ULine line = ULine.vline(this.rectangleArea.getHeight());
        ug = ug.apply(borderColor);
        ug.apply(UTranslate.dx(this.rectangleArea.getMinX())).draw(line);
        ug.apply(UTranslate.dx(this.rectangleArea.getMaxX())).draw(line);
    }

    private void drawUState(UGraphic ug, UmlDiagramType umlDiagramType, double rounded, double shadowing) {
        Stereotype stereotype;
        boolean withSymbol;
        HColor backColor;
        XDimension2D total = this.rectangleArea.getDimension();
        double suppY = this.clusterHeader.getTitle().calculateDimension(ug.getStringBounder()).getHeight() + 5.0;
        HColor borderColor = this.group.getColors().getColor(ColorType.LINE);
        if (borderColor == null) {
            borderColor = EntityImageStateCommon.getStyleState(this.group, this.skinParam).value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        }
        if ((backColor = this.group.getColors().getColor(ColorType.BACK)) == null) {
            backColor = EntityImageStateCommon.getStyleState(this.group, this.skinParam).value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        }
        HColor imgBackcolor = EntityImageStateCommon.getStyleStateBody(this.group, this.skinParam).value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        TextBlock attribute = this.group.getStateHeader(this.skinParam);
        double attributeHeight = attribute.calculateDimension(ug.getStringBounder()).getHeight();
        if (total.getWidth() == 0.0) {
            System.err.println("Cluster::drawUState issue");
            return;
        }
        UStroke stroke = this.group.getColors().getSpecificLineStroke();
        if (stroke == null) {
            stroke = EntityImageStateCommon.getStyleState(this.group, this.skinParam).getStroke();
        }
        RoundedContainer r = new RoundedContainer(total, suppY, attributeHeight + (double)(attributeHeight > 0.0 ? 5 : 0), borderColor, backColor, imgBackcolor, stroke, rounded, shadowing);
        r.drawU(ug.apply(this.rectangleArea.getPosition()));
        this.clusterHeader.getTitle().drawU(ug.apply(UTranslate.point(this.xyTitle)));
        if (attributeHeight > 0.0) {
            attribute.drawU(ug.apply(new UTranslate(this.rectangleArea.getMinX() + 5.0, this.rectangleArea.getMinY() + suppY + 2.5)));
        }
        boolean bl = withSymbol = (stereotype = this.group.getStereotype()) != null && stereotype.isWithOOSymbol();
        if (withSymbol) {
            EntityImageState.drawSymbol(ug.apply(borderColor), this.rectangleArea.getMaxX(), this.rectangleArea.getMaxY());
        }
    }

    public void setPosition(XPoint2D min, XPoint2D max) {
        this.rectangleArea = RectangleArea.build(min, max);
    }

    public boolean printCluster1(StringBuilder sb, Collection<SvekEdge> lines, StringBounder stringBounder) {
        List<SvekNode> tmp = this.getNodesOrderedTop(lines);
        if (tmp.size() == 0) {
            return false;
        }
        for (SvekNode node : tmp) {
            node.appendShape(sb, stringBounder);
        }
        return true;
    }

    private void printTogether(Together together, Collection<Together> otherTogethers, StringBuilder sb, List<SvekNode> nodesOrderedWithoutTop, StringBounder stringBounder, Collection<SvekEdge> lines, DotMode dotMode, GraphvizVersion graphvizVersion, UmlDiagramType type) {
        sb.append("subgraph " + this.getClusterId() + "t" + this.togetherCounter + " {\n");
        for (SvekNode node : nodesOrderedWithoutTop) {
            if (node.getTogether() != together) continue;
            node.appendShape(sb, stringBounder);
        }
        for (Cluster child : this.children) {
            if (child.group.getTogether() != together) continue;
            child.printInternal(sb, lines, stringBounder, dotMode, graphvizVersion, type);
        }
        for (Together otherTogether : otherTogethers) {
            if (otherTogether.getParent() != together) continue;
            this.printTogether(otherTogether, otherTogethers, sb, nodesOrderedWithoutTop, stringBounder, lines, dotMode, graphvizVersion, type);
        }
        sb.append("}\n");
        ++this.togetherCounter;
    }

    public SvekNode printCluster2(StringBuilder sb, Collection<SvekEdge> lines, StringBounder stringBounder, DotMode dotMode, GraphvizVersion graphvizVersion, UmlDiagramType type) {
        SvekNode added = null;
        LinkedHashSet<Together> togethers = new LinkedHashSet<Together>();
        List<SvekNode> nodesOrderedWithoutTop = this.getNodesOrderedWithoutTop(lines);
        for (SvekNode node : nodesOrderedWithoutTop) {
            Together together = node.getTogether();
            if (together == null) {
                node.appendShape(sb, stringBounder);
            } else {
                Cluster.addTogetherWithParents(togethers, together);
            }
            added = node;
        }
        for (Cluster child : this.children) {
            if (child.group.getTogether() == null) continue;
            Cluster.addTogetherWithParents(togethers, child.group.getTogether());
        }
        for (Together together : togethers) {
            if (together.getParent() != null) continue;
            this.printTogether(together, togethers, sb, nodesOrderedWithoutTop, stringBounder, lines, dotMode, graphvizVersion, type);
        }
        if (this.skinParam.useRankSame() && dotMode != DotMode.NO_LEFT_RIGHT_AND_XLABEL && !graphvizVersion.ignoreHorizontalLinks()) {
            this.appendRankSame(sb, lines);
        }
        for (Cluster child : this.children) {
            if (child.group.getTogether() != null) continue;
            child.printInternal(sb, lines, stringBounder, dotMode, graphvizVersion, type);
        }
        return added;
    }

    private static void addTogetherWithParents(Collection<Together> collection, Together together) {
        for (Together t = together; t != null; t = t.getParent()) {
            collection.add(t);
        }
    }

    public void printCluster3_forKermor(StringBuilder sb, Collection<SvekEdge> lines, StringBounder stringBounder, DotMode dotMode, GraphvizVersion graphvizVersion, UmlDiagramType type) {
        List<SvekNode> tmp = this.getNodes(EntityPosition.getNormals());
        if (tmp.size() == 0) {
            sb.append(this.getClusterId() + "empty [shape=point,label=\"\"];");
            SvekUtils.println(sb);
        } else {
            for (SvekNode node : tmp) {
                node.appendShape(sb, stringBounder);
            }
        }
        for (Cluster child : this.getChildren()) {
            child.printInternal(sb, lines, stringBounder, dotMode, graphvizVersion, type);
        }
    }

    private void printInternal(StringBuilder sb, Collection<SvekEdge> lines, StringBounder stringBounder, DotMode dotMode, GraphvizVersion graphvizVersion, UmlDiagramType type) {
        new ClusterDotString(this, this.skinParam).printInternal(sb, lines, stringBounder, dotMode, graphvizVersion, type);
    }

    private void appendRankSame(StringBuilder sb, Collection<SvekEdge> lines) {
        for (String same : this.getRankSame(lines)) {
            sb.append(same);
            SvekUtils.println(sb);
        }
    }

    private Set<String> getRankSame(Collection<SvekEdge> lines) {
        HashSet<String> rankSame = new HashSet<String>();
        for (SvekEdge l : lines) {
            String same;
            if (l.hasEntryPoint()) continue;
            String startUid = l.getStartUidPrefix();
            String endUid = l.getEndUidPrefix();
            if (!this.isInCluster(startUid) || !this.isInCluster(endUid) || (same = l.rankSame()) == null) continue;
            rankSame.add(same);
        }
        return rankSame;
    }

    private boolean isInCluster(String uid) {
        for (SvekNode node : this.nodes) {
            if (!node.getUid().equals(uid)) continue;
            return true;
        }
        return false;
    }

    public String getClusterId() {
        return "cluster" + this.color;
    }

    static String getSpecialPointId(Entity group) {
        return CENTER_ID + group.getUid();
    }

    String getMinPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "minPoint" + this.color;
        }
        return null;
    }

    String getMaxPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "maxPoint" + this.color;
        }
        return null;
    }

    public boolean isLabel() {
        return this.getTitleAndAttributeHeight() > 0 && this.getTitleAndAttributeWidth() > 0;
    }

    int getColor() {
        return this.color;
    }

    int getTitleColor() {
        return this.colorTitle;
    }

    private final HColor getBackColor(UmlDiagramType umlDiagramType, Style style) {
        if (this.group.isRoot()) {
            return null;
        }
        HColor result = this.group.getColors().getColor(ColorType.BACK);
        if (result != null) {
            return result;
        }
        return style.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
    }

    boolean isClusterOf(Entity ent) {
        if (!ent.isGroup()) {
            return false;
        }
        return this.group == ent;
    }

    public static HColor getBackColor(HColor backColor, Stereotype stereotype, SName styleName, USymbol symbol, StyleBuilder styleBuilder, HColorSet colorSet, GroupType groupType) {
        Style style = Cluster.getDefaultStyleDefinition(styleName, symbol, groupType).getMergedStyle(styleBuilder);
        if (backColor == null) {
            backColor = style.value(PName.BackGroundColor).asColor(colorSet);
        }
        if (backColor == null || backColor.equals(HColors.transparent())) {
            backColor = HColors.transparent();
        }
        return backColor;
    }

    public final int getColorNoteTop() {
        return this.colorNoteTop;
    }

    public final int getColorNoteBottom() {
        return this.colorNoteBottom;
    }

    public XDimension2D getTitleDimension(StringBounder stringBounder) {
        return this.clusterHeader.getTitle().calculateDimension(stringBounder);
    }

    public MagneticBorder getMagneticBorder() {
        if (this.group.getUSymbol() == null) {
            return new MagneticBorderNone();
        }
        USymbol uSymbol = this.group.getUSymbol();
        PackageStyle packageStyle = this.group.getPackageStyle();
        if (packageStyle == null) {
            packageStyle = this.skinParam.packageStyle();
        }
        UmlDiagramType umlDiagramType = UmlDiagramType.CLASS;
        Style style = Cluster.getDefaultStyleDefinition(umlDiagramType.getStyleName(), uSymbol, this.group.getGroupType()).withTOBECHANGED(this.group.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        UStroke stroke = Cluster.getStrokeInternal(this.group, style);
        ClusterDecoration decoration = new ClusterDecoration(packageStyle, this.group.getUSymbol(), this.clusterHeader.getTitle(), this.clusterHeader.getStereo(), this.rectangleArea, stroke);
        TextBlock textBlock = decoration.getTextBlock(HColors.BLACK, HColors.BLACK, 0.0, 0.0, this.skinParam.getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null), this.skinParam.getStereotypeAlignment(), 0.0);
        final MagneticBorder orig = textBlock.getMagneticBorder();
        return new MagneticBorder(){

            @Override
            public UTranslate getForceAt(StringBounder stringBounder, XPoint2D position) {
                return orig.getForceAt(stringBounder, position.move(-Cluster.this.rectangleArea.getMinX(), -Cluster.this.rectangleArea.getMinY()));
            }
        };
    }
}

