// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.text;

public class FoxSignature {

	private static final long masks[] = new long[127];
	private static final long MASK_SPACES;
	private static final long MASK_SPECIAL1;

	static {
		final String full = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0!\"#$%&\'()*+,-./:;<=>?@[\\]^_{|}~";
		long m = 1L;
		MASK_SPACES = m;
		m = m << 1;
		MASK_SPECIAL1 = m;
		m = m << 1;
		for (int i = 0; i < full.length(); i++) {
			char ch = full.charAt(i);
			masks[ch] = m;
			if (ch >= 'A' && ch <= 'Z') {
				ch = (char) (ch + ('a' - 'A'));
				masks[ch] = m;
			} else if (ch == '.' || ch == '=' || ch == '-' || ch == '~')
				masks[ch] |= MASK_SPECIAL1;
			m = m << 1;
		}
		masks[' '] = MASK_SPACES;
		masks['\t'] = MASK_SPACES;
		masks['\r'] = MASK_SPACES;
		masks['\n'] = MASK_SPACES;
		masks['\f'] = MASK_SPACES;

	}

	public static long getSpecialSpaces() {
		return MASK_SPACES;
	}

	public static long getSpecial1() {
		return MASK_SPECIAL1;
	}

	public static void printMe() {
		for (int i = 0; i < masks.length; i++)
			if (masks[i] > 0) {
				final char ch = (char) i;
				System.err.println("ch=" + ch + " " + masks[i]);
			}

	}

	private static long getMask(char ch) {
		if (ch < masks.length)
			return masks[ch];
		else if (ch == '\u00A0')
			return MASK_SPACES;

		return 0L;
	}

	public static long getFoxSignatureFromRealString(String s) {
		long result = 0;
		for (int i = 0; i < s.length(); i++)
			result = result | getMask(s.charAt(i));
		return result;
	}

	public static long getFoxSignatureFromRegex(String s) {
		long result = 0;
		for (int i = 0; i < s.length(); i++) {
			if (s.charAt(i) == '.') {
				if (s.charAt(i + 1) == '+' || s.charAt(i + 1) == '*')
					i++;
				else
					throw new IllegalArgumentException(s);
			} else if (s.charAt(i) == '\\') {
				if (s.charAt(i + 1) == 'b')
					i++;
				else if (Character.isLetterOrDigit(s.charAt(i + 1)))
					throw new IllegalArgumentException(s);
			} else {
				if (i + 1 < s.length() && (s.charAt(i + 1) == '?' || s.charAt(i + 1) == '*')) {
					i++;
					continue;
				}
				result = result | getMask(s.charAt(i));
				if (i + 1 < s.length() && s.charAt(i + 1) == '+') {
					i++;
				}
			}
		}
		return result;
	}

	public static String backToString(long check) {
		final StringBuilder sb = new StringBuilder();
		for (int i = 0; i < masks.length; i++)
			if (masks[i] != 0L && (check & masks[i]) != 0L) {
				final char ch = (char) i;
				sb.append(ch);
			}
		return sb.toString();
	}

}
