// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.dot;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;

import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SFile;

public class ProcessRunner {
	// ::remove file when __CORE__

	private final String[] cmd;
	private String error;
	private String out;

	public ProcessRunner(String[] cmd) {
		this.cmd = cmd;
	}

	public ProcessState run(byte[] in, OutputStream redirection) {
		return run(in, redirection, null);
	}

	public ProcessState run(byte[] in, OutputStream redirection, SFile dir) {
		Process process = null;
		try {
			final ProcessBuilder builder = new ProcessBuilder(cmd);
			if (dir != null)
				builder.directory(dir.conv());
			builder.redirectErrorStream(true);

			process = builder.start();

			// Handling input to the process
			if (in != null)
				try (OutputStream os = process.getOutputStream()) {
					os.write(in);
				}

			final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
			try (InputStream is = process.getInputStream()) {
				final byte[] buffer = new byte[1024];
				int length;
				while ((length = is.read(buffer)) != -1) {
					outputStream.write(buffer, 0, length);
					if (redirection != null)
						redirection.write(buffer, 0, length);
				}
			}

			// Wait for process to terminate
			final long timeoutMs = OptionFlags.getInstance().getTimeoutMs();
			final boolean finished = process.waitFor(timeoutMs, TimeUnit.MILLISECONDS);
			outputStream.close();
			if (finished) {
				this.out = new String(outputStream.toByteArray(), "UTF-8");
				return ProcessState.TERMINATED_OK();
			}

			return ProcessState.TIMEOUT();

		} catch (Throwable e) {
			Logme.error(e);
			this.error = e.toString();
			return ProcessState.EXCEPTION(e);
		} finally {
			if (process != null && out == null && process.isAlive()) {
				// Process did not finish in time, kill it
				process.destroy();
				// Not really sure that we should overwrite "this.error" here
				this.error = "Timeout - kill";
				try {
					if (process.waitFor(500, TimeUnit.MILLISECONDS) == false) {
						process.destroyForcibly();
						this.error = "Timeout - kill force";
					}
				} catch (InterruptedException e) {
					// Nothing we can really do
					e.printStackTrace();
				}

			}

		}
	}

	public final String getError() {
		return error;
	}

	public final String getOut() {
		return out;
	}

}
