// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.api.v2;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Optional;

import net.sourceforge.plantuml.core.Diagram;

/**
 * Provides an interface to retrieve the results of a diagram processing
 * operation. This interface allows for obtaining either a {@link Diagram}
 * object if the operation was successful, or an error message if the operation
 * failed, along with the line number where the error occurred.
 */
public interface DiagramReturn {

	/**
	 * Retrieves the {@link Diagram} generated by the diagram processing operation.
	 * 
	 * @return the generated {@link Diagram}, or {@code null} if there was an error
	 *         during the diagram generation process, implying that no valid diagram
	 *         could be created.
	 */
	public Diagram getDiagram();

	/**
	 * Retrieves the error message associated with the diagram processing operation.
	 * 
	 * @return the error message if an error occurred, or {@code null} if the
	 *         operation completed successfully and a valid diagram was produced.
	 */
	public String error();

	/**
	 * Retrieves the line number where an error occurred during the diagram
	 * processing operation. This can help in debugging the source of the error in
	 * the input provided.
	 *
	 * @return an {@link Optional} containing the line number of the error if an
	 *         error occurred; otherwise, an empty {@link Optional} if the operation
	 *         completed successfully without errors.
	 */
	public Optional<Integer> getErrorLine();

	/**
	 * Converts the generated diagram to an image representation. This can be useful for displaying
	 * the diagram in graphical user interfaces or for saving it as a file.
	 *
	 * @return a {@link BufferedImage} representing the diagram.
	 * @throws IOException if there is an error during the image generation process, such as an issue
	 *         writing to a file or generating the image from the diagram.
	 */
	public BufferedImage asImage() throws IOException;

	/**
	 * Retrieves the root cause of the error occurred during the diagram processing operation.
	 * This method can be particularly useful for obtaining detailed information about exceptions
	 * that were caught during the processing of the diagram.
	 *
	 * @return a {@link Throwable} object representing the root cause of the error, or {@code null}
	 *         if the operation completed successfully without any exceptions.
	 */
	public Throwable getRootCause();

}
