// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package  jcckit.util;

import java.util.Vector;

/**
 *  A helper class for formatting numbers according to
 *  a <tt>printf</tt>-like format string. Each instance of
 *  this class is initialized by a format string for a
 *  single number.
 *
 *  @author Franz-Josef Elmer
 */
public class Format implements TicLabelFormat {
  /**
   *  Creates a new instance based of specified key-value pair of the
   *  specified configuration parameters.
   *  @param config Config parameters.
   *  @param key The key of the key-value pair in <tt>config</tt> containing
   *         the format string.
   *  @return <tt>null</tt> if undefined key-value pair or format string
   *          is an empty string.
   *  @throws FactoryException if the format string is invalid.
   */
  public static Format create(ConfigParameters config, String key) {
    Format result = null;
    String format = config.get(key, null);
    if (format != null && format.length() > 0) {
      try {
        result = new Format(format);
      } catch (Exception e) {
        throw new FactoryException(config, key, e);
      }
    }
    return result;
  }

  private final FormatElement[] _formatElements;
  private final Vector _staticParts;

  /**
   *  Creates an instance for the specified format string.
   *  The format string is an alternation of some static texts and
   *  format elements.
   *  A format element has to start with `%` and it must end with
   *  one of the following format descriptors:
   *  <table border=0 cellpadding=5>
   *    <tr><td><tt>d</tt></td>
   *        <td>decimal integer</td></tr>
   *    <tr><td><tt>o</tt></td>
   *        <td>octal integer</td></tr>
   *    <tr><td><tt>x</tt></td>
   *        <td>hex integer</td></tr>
   *    <tr><td><tt>f</tt></td>
   *        <td>floating point number with a fixed decimal point</td></tr>
   *    <tr><td><tt>e,&nbsp;E</tt></td>
   *        <td>floating point number in logarithmic format</td></tr>
   *    <tr><td><tt>g,&nbsp;G</tt></td>
   *        <td>floating point number rendered either in fixed-decimal
   *            format of logarithmic format depending on the size of
   *            the mantissa.</td></tr>
   *  </table>
   *  The characters between `%` and the decriptor are optional.
   *  They can be grouped into
   *  <ul><li>modifier<br>
   *          it is
   *          <ul><li>'-' if the formated result should be flushed left
   *              <li>'+' if the sign should be always appear
   *              <li>'0' if the leading space should be filled with zeros
   *          </ul>
   *      <li>width<br>
   *          a decimal number given the minimum number of characters
   *          of the result
   *      <li>precision
   *  </ul>
   *  A plain `%` is coded as `%%`.
   *  @param formatString The format string.
   *  @exception IllegalArgumentException if invalid format string.
   */
  public Format(String formatString) {
    _staticParts = new Vector();
    Vector formatElements = new Vector();
    StringBuffer part = new StringBuffer();
    boolean insideFormatElement = false;
    boolean atPercentSymbol = false;
    for (int i = 0, n = formatString.length(); i < n; i++) {
      char c = formatString.charAt(i);
      if (insideFormatElement) {
        part.append(c);
        if (FormatElement.DESCRIPTORS.indexOf(c) >= 0) {
          formatElements.addElement(new String(part));
          part.setLength(0);
          insideFormatElement = false;
        }
      } else if (atPercentSymbol) {
        atPercentSymbol = false;
        if (c != '%') {
          _staticParts.addElement(new String(part));
          part.setLength(0);
          insideFormatElement = true;
        }
        part.append(c);
        if (FormatElement.DESCRIPTORS.indexOf(c) >= 0) {
          formatElements.addElement(new String(part));
          part.setLength(0);
          insideFormatElement = false;
        }
      } else {
        if (c == '%') {
          atPercentSymbol = true;
        } else {
          part.append(c);
        }
      }
    }
    if (insideFormatElement) {
      formatElements.addElement(new String(part));
    } else {
      _staticParts.addElement(new String(part));
    }
    
    _formatElements = new FormatElement[formatElements.size()];
    for (int i = 0; i < _formatElements.length; i++) {
      _formatElements[i] 
          = new FormatElement((String) formatElements.elementAt(i));
    }
  }

  /**
   * Format a number.
   * If there are no format elements the numbers will be ignored. 
   * If there are more than one format elements the
   * additional format elements will be ignored and only the static parts
   * are taken.
   * @param number Number to be formated.
   * @return Formated number.
   */
  public String form(long number) {
    StringBuffer result = new StringBuffer();
    result.append(_staticParts.elementAt(0));
    if (_formatElements.length > 0) {
      _formatElements[0].form(result, number);
    }
    return appendRest(result);
  }
  
  /**
   * Format a number.
   * If there are no format elements the numbers will be ignored. 
   * If there are more than one format elements the
   * additional format elements will be ignored and only the static parts
   * are taken.
   * @param number Number to be formated.
   * @return Formated number.
   */
  public String form(double number) {
    StringBuffer result = new StringBuffer();
    result.append(_staticParts.elementAt(0));
    if (_formatElements.length > 0) {
      _formatElements[0].form(result, number);
    }
    return appendRest(result);
  }
  
  private String appendRest(StringBuffer buffer) {
    for (int i = 1, n = _staticParts.size(); i < n; i++) {
      buffer.append(_staticParts.elementAt(i));
    }
    return new String(buffer);
  }
  
  /**
   * Format an array of double numbers.
   * If there are less format elements than numbers the additional numbers
   * will be ignored. If there are less numbers than format elements the
   * additional format elements will be ignored and only the static parts
   * are taken.
   * @param numbers Numbers to be formated.
   * @return Formated numbers.
   */
  public String form(double[] numbers) {
    StringBuffer result = new StringBuffer();
    for (int i = 0, n = _staticParts.size(); i < n; i++) {
      result.append(_staticParts.elementAt(i));
      if (i < _formatElements.length && i < numbers.length) {
        _formatElements[i].form(result, numbers[i]);
      }
    }
    return new String(result);
  }
}
