// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.plot;

import java.awt.Color;

import jcckit.graphic.ClippingShape;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicalComposite;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.LineAttributes;
import jcckit.graphic.Polygon;
import jcckit.graphic.ShapeAttributes;
import jcckit.util.ConfigParameters;
import jcckit.util.Factory;

/**
 *  A simple curve is the basic implementation of the {@link Curve} interface.
 * 
 *  @author Franz-Josef Elmer
 */
public class SimpleCurve implements Curve {
    // ::remove folder when __HAXE__
  /** Configuration parameter key. */
  public static final String SYMBOL_FACTORY_KEY = "symbolFactory",
                             WITH_LINE_KEY = "withLine",
                             SOFT_CLIPPING_KEY = "softClipping",
                             LINE_ATTRIBUTES_KEY = "lineAttributes",
                             INITIAL_HINT_FOR_NEXT_POINT_KEY
                                      = "initialHintForNextPoint";  
  private final ClippingShape _clippingShape;
  private final SymbolFactory _symbolFactory;
  private final GraphicalComposite _symbols;
  private final GraphicalComposite _completeCurve;
  private final GraphicalElement _legendSymbol;
  private final Hint _initialHintForNextPoint;
  private final Polygon _curve;
  private final boolean _softClipping;
  private Hint _hintForNextPoint;

  /**
   * Creates a new curve. The parameter <tt>config</tt> contains:
   * <table border=1 cellpadding=5>
   * <tr><th>Key &amp; Default Value</th><th>Type</th><th>Mandatory</th>
   *     <th>Description</th></tr>
   * <tr><td><tt>initialHintForNextPoint = null</tt></td>
   *     <td><tt>ConfigParameters</tt></td><td>no</td>
   *     <td>Definition of an initial {@link Hint} for the first curve point.
   *         </td></tr>
   * <tr><td><tt>lineAttributes = </tt>a {@link ShapeAttributes}
   *         instances with default values and line colors based on
   *         the formula <tt>Color.getHSBColor(curveIndex/6,1,0.8)</tt></td>
   *     <td><tt>ConfigParameters</tt></td><td>no</td>
   *     <td>Configuration parameters of an instances of 
   *         {@link jcckit.graphic.GraphicAttributes} for the 
   *         {@link Polygon Polygons} connecting curve points.</td></tr>
   * <tr><td><tt>symbolFactory = null</tt></td>
   *     <td><tt>ConfigParameters</tt></td><td>no</td>
   *     <td>Configuration parameters defining an instances of 
   *         {@link SymbolFactory} for the {@link Symbol Symbols} 
   *         decorating curve points.</td></tr>
   * <tr><td><tt>softClipping = true</tt></td>
   *     <td><tt>boolean</tt></td><td>no</td>
   *     <td>If <tt>true</tt> no explicit clipping takes
   *         place but the symbol is not drawn if the corresponding curve
   *         point is outside the axis box.<br> 
   *         If <tt>false</tt> the symbol is
   *         drawn in any case but it may be clipped by the axis box.
   *         Soft-clipping should be set to <tt>false</tt> if the 
   *         symbols are not located around the curve point (like for bars).
   *         </td></tr>
   * <tr><td><tt>withLine = true</tt></td>
   *     <td><tt>boolean</tt></td><td>no</td>
   *     <td>If <tt>true</tt> curve points are connected by a 
   *         {@link jcckit.graphic.Polygon}.</td></tr>
   * </table>
   * @param config Configuration parameters described above.
   * @param curveIndex Index of this curve in the collection of curves
   *        defining a {@link Plot}. 
   * @param numberOfCurves Number of curves in this collection.
   * @param clippingShape Clipping shape. Can be <tt>null</tt>. 
   * @param legend Legend. Will be used to calculate the legend symbol.
   * @throws IllegalArgumentException if <tt>symbolFactory == null</tt> and
   *         <tt>withLine == false</tt>.
   *
   */
  public SimpleCurve(ConfigParameters config, int curveIndex, 
                     int numberOfCurves, ClippingShape clippingShape, 
                     Legend legend) {
    _symbolFactory = (SymbolFactory) Factory.createOrGet(
        config.getNode(SYMBOL_FACTORY_KEY), null);
    boolean withLine = config.getBoolean(WITH_LINE_KEY, true);
    LineAttributes lineAttributes = (LineAttributes) Factory.createOrGet(
        config.getNode(LINE_ATTRIBUTES_KEY),
        new ShapeAttributes(null, Color.getHSBColor((curveIndex % 6) / 6f, 
                                                    1f, 0.8f), 
                            0, null));
    if (_symbolFactory != null || withLine) {
      _clippingShape = clippingShape;
      _completeCurve = new GraphicalComposite(null);
      if (withLine) {
        GraphicalComposite container = new GraphicalComposite(clippingShape);
        _curve = new Polygon(lineAttributes, false);
        container.addElement(_curve);
       _completeCurve.addElement(container);
      } else {
        _curve = null;
      }
      _softClipping = config.getBoolean(SOFT_CLIPPING_KEY, true);
      if (_symbolFactory != null) {
        _symbols = new GraphicalComposite(_softClipping ? null 
                                                        : clippingShape);
        _completeCurve.addElement(_symbols);
      } else {
        _symbols = null;
      }
    } else {
      throw new IllegalArgumentException(
          "Either a SymbolFactory must exist or withLines == true.");
    }
    _hintForNextPoint = _initialHintForNextPoint 
        = (Hint) Factory.createOrGet(
            config.getNode(INITIAL_HINT_FOR_NEXT_POINT_KEY), null);
    _legendSymbol = legend.createSymbol(curveIndex, numberOfCurves, 
                                        _symbolFactory, withLine, 
                                        lineAttributes);
  }

  /**
   * Returns the graphical representation of a curve. 
   * @return always the same instance.
   */
  public GraphicalElement getView() {
    return _completeCurve;
  }

  /** Returns the legend symbol. */
  public GraphicalElement getLegendSymbol() {
    return _legendSymbol;
  }

  /** Appends a new point to the curve if inside the clipping shape. */
  public Hint addPoint(GraphPoint point, Hint hintFromPreviousCurve) {
    if (_curve != null) {
      _curve.addPoint(point);
    }
    Hint hintForNextCurve = hintFromPreviousCurve;
    if (_symbolFactory != null) {
      Symbol symbol = _symbolFactory.createSymbol(point, _hintForNextPoint,
                                                  hintFromPreviousCurve);
      if (_clippingShape == null || !_softClipping 
          || _clippingShape.isInside(point)) {
        _symbols.addElement(symbol.getSymbol());
      }
      _hintForNextPoint = symbol.getHintForNextPoint();
      hintForNextCurve = symbol.getHintForNextCurve();
    }
    return hintForNextCurve;
  }

  public void removeAllPoints() {
    if (_curve != null) {
      _curve.removeAllPoints();
    }
    if (_symbols != null) {
      _symbols.removeAllElements();
    }
    _hintForNextPoint = _initialHintForNextPoint;
  }
}
