// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.data;

/**
 *  Event to be sent to a {@link DataListener}.
 *
 *  @author Franz-Josef Elmer
 */
public class DataEvent {
  private final DataContainer _container;
  private final DataEventType _type;
  private final int _index;
  private final DataElement _deletedElement;

  /**
   *  Creates an instance for the specified parameters.
   *  @param container The container which has been changed.
   *  @param type Type of change.
   *  @param index Index of the element which has been added, inserted,
   *               replaced, or removed.
   *  @param deletedElement Element which has been replaced or removed.
   */
  private DataEvent(DataContainer container, DataEventType type, int index,
                    DataElement deletedElement) {
    _container = container;
    _type = type;
    _index = index;
    _deletedElement = deletedElement;
  }

  /**
   *  Creates an event of type {@link DataEventType#ELEMENT_ADDED} for the
   *  specified container.
   *  @param container Container where an element has been added.
   *  @return <tt>ELEMENT_ADDED</tt> event.
   */
  public static final DataEvent createAddEvent(DataContainer container) {
    return new DataEvent(container, DataEventType.ELEMENT_ADDED,
                         container.getNumberOfElements() - 1, null);
  }

  /**
   *  Creates an event of type {@link DataEventType#ELEMENT_INSERTED} for the
   *  specified container.
   *  @param container Container where an element has been inserted.
   *  @param index Index at which an element has been inserted.
   *  @return <tt>ELEMENT_INSERTED</tt> event.
   */
  public static final DataEvent createInsertEvent(DataContainer container,
                                                  int index) {
    return new DataEvent(container, DataEventType.ELEMENT_INSERTED, index, 
                         null);
  }

  /**
   *  Creates an event of type {@link DataEventType#ELEMENT_REPLACED} for the
   *  specified container.
   *  @param container Container where an element has been replaced.
   *  @param index Index of the replaced element.
   *  @param replacedElement The previous element at <tt>index</tt>.
   *  @return <tt>ELEMENT_REPLACED</tt> event.
   */
  public static final DataEvent createReplaceEvent(DataContainer container,
                                      int index, DataElement replacedElement) {
    return new DataEvent(container, DataEventType.ELEMENT_REPLACED, index, 
                         replacedElement);
  }

  /**
   *  Creates an event of type {@link DataEventType#ELEMENT_REMOVED} for the
   *  specified container.
   *  @param container Container where an element has been removed.
   *  @param index Index of the removed element.
   *  @param removedElement The previous element at <tt>index</tt>.
   *  @return <tt>ELEMENT_REMOVED</tt> event.
   */
  public static final DataEvent createRemoveEvent(DataContainer container,
                                      int index, DataElement removedElement) {
    return new DataEvent(container, DataEventType.ELEMENT_REMOVED, index, 
                         removedElement);
  }

  /** Returns the container. */
  public DataContainer getContainer() {
    return _container;
  }

  /** 
   * Returns the event type. Will be one of the constants 
   * {@link DataEventType#ELEMENT_ADDED}, 
   * {@link DataEventType#ELEMENT_INSERTED}, 
   * {@link DataEventType#ELEMENT_REMOVED}, or 
   * {@link DataEventType#ELEMENT_REPLACED}.
   */
  public DataEventType getType() {
    return _type;
  }

  /** Returns the index. */
  public int getIndex() {
    return _index;
  }

  /**
   *  Returns the deleted element.
   *  @return <tt>null</tt> if either an element has been added or inserted.
   */
  public DataElement getDeletedElement() {
    return _deletedElement;
  }
}
