// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.plot;

import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalComposite;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.Rectangle;
import jcckit.util.ConfigParameters;
import jcckit.util.Factory;

/**
 * Symbol factory for creating symbols with error bars. It wraps 
 * a {@link SymbolFactory} for creating the symbol. The error bars
 * are {@link Rectangle Rectangles}. 
 * <p>
 * Curves with error bars are based on <em>two</em> 
 * {@link jcckit.data.DataCurve DataCurves}:
 * <ol><li>The plain curve.
 *     <li>An instance which stores the errors in <i>x</i> and <i>y</i>.
 *         It is assumed that the errors are positive values defining
 *         the error symmetrically around the curve points.
 * </ol>
 * <p>
 * The <tt>ErrorBarFactory</tt> needs an instance of {@link PositionHint}
 * as initial {@link Hint} for the next curve. Its origin must be
 * the origin of the data coordinate system in device-independent coordinates.
 * The position of <tt>PositionHint</tt> must be undefined.
 * 
 * @author Franz-Josef Elmer
 */
public class ErrorBarFactory implements SymbolFactory {
  /** Configuration parameter key. */
  public static final String SYMBOL_FACTORY_KEY = "symbolFactory";

  private final SymbolFactory _symbolFactory;
  private final GraphicAttributes _attributes;
  private final double _size;

  /**
   * Creates an instance from the specified configuration parameters.
   * <table border=1 cellpadding=5>
   * <tr><th>Key &amp; Default Value</th><th>Type</th><th>Mandatory</th>
   *     <th>Description</th></tr>
   * <tr><td><tt>symbolFactory = null</tt></td>
   *     <td><tt>ConfigParameters</tt></td><td>no</td>
   *     <td>Definition of the wrapped {@link SymbolFactory} which generates
   *         the curve symbol without bars. By default an empty
   *         {@link GraphicalComposite} will be created.</td></tr>
   * <tr><td><tt>size = 0</tt></td>
   *     <td><tt>double</tt></td><td>no</td>
   *     <td>Width of the error bars.</td></tr>
   * <tr><td><tt>attributes = null</tt></td>
   *     <td><tt>ConfigParameters</tt></td><td>no</td>
   *     <td>Definition of the {@link GraphicAttributes} of the error 
   *         bars.</td></tr>
   * </table>
   */
  public ErrorBarFactory(ConfigParameters config) {
    _symbolFactory = (SymbolFactory) Factory.createOrGet(
        config.getNode(SYMBOL_FACTORY_KEY), null);
    _size = config.getDouble(SIZE_KEY, 0);
    _attributes = (GraphicAttributes) Factory.createOrGet(
        config.getNode(ATTRIBUTES_KEY), null);
  }

  /**
   * Creates the legend symbol. Calls the wrapped {@link SymbolFactory}
   * or returns an empty instance of {@link GraphicalComposite} if undefined.
   */
  public GraphicalElement createLegendSymbol(GraphPoint centerPosition,
                                             double size) {
    return _symbolFactory == null ? new GraphicalComposite(null)
              : _symbolFactory.createLegendSymbol(centerPosition, size);
  }

  /**
   * Creates either the curve symbol or the error bars. Error bars are
   * created when <tt>hintFromPreviousCurve</tt> is an instance of
   * {@link PositionHint} and its position attribute is not <tt>null</tt>.
   * Otherwise the curve symbol is created. The position attributes stores
   * the curve point (in device-independent coordinates). The origin is
   * always as set in the initial <tt>PositionHint</tt>. The hint for
   * the next curve wrapped by the returned <tt>Symbol</tt> is always
   * a <tt>PositionHint</tt>.
   */
  public Symbol createSymbol(GraphPoint point, Hint hintFromPreviousPoint,
                             Hint hintFromPreviousCurve) {
    GraphPoint origin = new GraphPoint(null);
    GraphPoint position = null;
    if (hintFromPreviousCurve instanceof PositionHint) {
      origin = ((PositionHint) hintFromPreviousCurve).getOrigin();
      position = ((PositionHint) hintFromPreviousCurve).getPosition();
    }
    if (position == null) {
      if (_symbolFactory == null) {
        return new Symbol(new GraphicalComposite(null), hintFromPreviousPoint,
                          new PositionHint(origin, point));
      } else {
        return _symbolFactory.createSymbol(point, hintFromPreviousPoint,
                                           new PositionHint(origin, point));
      }
    } else {
      double xError = point.getX() - origin.getX();
      double yError = point.getY() - origin.getY();
      GraphicalComposite errorBars = new GraphicalComposite(null);
      if (xError > 0) {
        errorBars.addElement(new Rectangle(position, 2 * xError, _size, 
                                           _attributes));
      }
      if (yError > 0) {
        errorBars.addElement(new Rectangle(position, _size, 2 * yError, 
                                           _attributes));
      }
      return new Symbol(errorBars, hintFromPreviousPoint, 
                        new PositionHint(origin, null));
    }
  }
}
