// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.graphic;

import java.util.Vector;

/**
 *  Container for {@link GraphicalElement GraphicalElements}.
 *
 *  @author Franz-Josef Elmer
 */
public class GraphicalComposite implements GraphicalElement {
  private final Vector _elements = new Vector();
  private final ClippingShape _clippingShape;

  /**
   *  Creates an instance with the specified clipping shape.
   *  @param clippingShape Clipping shape or <tt>null</tt> if no clipping.
   */
  public GraphicalComposite(ClippingShape clippingShape) {
    _clippingShape = clippingShape;
  }

  /**
   *  Returns the clipping shape.
   *  @return <tt>null</tt> if no clipping should be applied.
   */
  public ClippingShape getClippingShape() {
    return _clippingShape;
  }

  /** 
   * Adds the specified element at the end of the list of elements. 
   * @param element Element to be added. <tt>null</tt> is not allowed.
   * @throws NullPointerException if <tt>element == null</tt>
   */
  public void addElement(GraphicalElement element) {
    if (element == null) {
      throwNullPointerException();
    } else {
      _elements.addElement(element);
    }
  }

  /** Remove all elements. */
  public void removeAllElements() {
    _elements.removeAllElements();
  }

  /**
   * Replaces the specified element at the specified index of
   * the list of elements.
   * @param index Index of the element to be replaced.
   * @param element New element. <tt>null</tt> is not allowed.
   * @throws NullPointerException if <tt>element == null</tt>
   */
  public void replaceElementAt(int index, GraphicalElement element) {
    if (element == null) {
      throwNullPointerException();
    } else {
      _elements.setElementAt(element, index);
    }
  }
  
  private void throwNullPointerException() {
    throw new NullPointerException(
        "A null as an GraphicalElement is not allowed");
  }

  /**
   *  Renders all {@link GraphicalElement GraphicalElements} in the sequence
   *  they have been added.
   *  @param renderer Renderer which implements all renderer interfaces
   *         necessary to render the child elements.
   *  @throws IllegalArgumentException if <tt>renderer</tt> is not
   *          an instance of <tt>GraphicalCompositeRenderer</tt>.
   */
  public void renderWith(Renderer renderer) {
    if (renderer instanceof GraphicalCompositeRenderer) {
      GraphicalCompositeRenderer r = (GraphicalCompositeRenderer) renderer;
      r.startRendering(this);
      for (int i = 0, n = _elements.size(); i < n; i++) {
        ((GraphicalElement) _elements.elementAt(i)).renderWith(r);
      }
      r.finishRendering(this);
    } else {
      throw new IllegalArgumentException(renderer
                      + " does not implements GraphicalCompositeRenderer.");
    }
  }
}
