// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package zext.plantuml.com.ctreber.acearth.shader;

import java.awt.Color;

/**
 * <p>Shader for projections which display the whole surface.</p>
 *
 * <p>&copy; 2002 Christian Treber, ct@ctreber.com (Nov 11, 2002)</p>
 * @author Christian Treber, ct@ctreber.com
 *
 */
public class ShaderDefault extends Shader
{
  public Color[] getShadedColors(int pRowNo, int[] pRowTypes)
  {
    final double y = fProjection.inverseProjectY(fProjection.inverseFinalizeY(pRowNo));

    // conceptually, on each iteration of the i loop, we want:
    //
    //   x = Math.sin(INV_XPROJECT(i)) * sqrt(1 - (y*y));
    //   z = cos(INV_XPROJECT(i)) * sqrt(1 - (y*y));
    //
    // computing this directly is rather expensive, however, so we only
    // compute the first (i=0) pair of values directly; all other pairs
    // (i>0) are obtained through successive rotations of the original
    // pair (by inv_proj_scale radians).
    //

    // compute initial (x, z) values
    double tmp = Math.sqrt(1 - (y * y));
    double x = Math.sin(fProjection.inverseFinalizeX(0)) * tmp;
    double z = Math.cos(fProjection.inverseFinalizeX(0)) * tmp;

    // compute rotation coefficients used
    // to find subsequent (x, z) values
    tmp = 1 / fProjection.getScale();
    final double sin_theta = Math.sin(tmp);
    final double cos_theta = Math.cos(tmp);

    // save a little computation in the inner loop
    final double lYBySunVectorY = y * fLightVector.getY();

    // use i_lim to encourage compilers to register loop limit
    final Color[] lColors = new Color[pRowTypes.length];
    for(int lColNo = 0; lColNo < pRowTypes.length; lColNo++)
    {
      double lSunValue = (x * fLightVector.getX()) + lYBySunVectorY +
        (z * fLightVector.getZ());
      lColors[lColNo] = getShadedColorForType(pRowTypes[lColNo], lSunValue);

      // compute next (x, z) values via 2-d rotation
      tmp = (cos_theta * z) - (sin_theta * x);
      x = (sin_theta * z) + (cos_theta * x);
      z = tmp;
    }

    return lColors;
  }
}
