// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.stats;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.api.NumberAnalyzed;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.stats.api.StatsColumn;
import net.sourceforge.plantuml.stats.api.StatsLine;
import net.sourceforge.plantuml.stats.api.StatsTable;

public class FormatCounter {

	private ConcurrentMap<FileFormat, NumberAnalyzed> data = new ConcurrentHashMap<FileFormat, NumberAnalyzed>();

	public FormatCounter(String prefix) {
		for (FileFormat format : FileFormat.values()) {
			final String key = prefix + format.name();
			data.put(format, new NumberAnalyzed(key));
		}

	}

	public void plusOne(FileFormat fileFormat, long duration) {
		final NumberAnalyzed n = data.get(fileFormat);
		n.addValue(duration);
	}

	private StatsLine createLine(String name, NumberAnalyzed n) {
		final Map<StatsColumn, Object> result = new EnumMap<StatsColumn, Object>(StatsColumn.class);
		result.put(StatsColumn.FORMAT, name);
		result.put(StatsColumn.GENERATED_COUNT, n.getNb());
		result.put(StatsColumn.GENERATED_MEAN_TIME, n.getMean());
		result.put(StatsColumn.GENERATED_STANDARD_DEVIATION, n.getStandardDeviation());
		result.put(StatsColumn.GENERATED_MAX_TIME, n.getMax());
		return new StatsLineImpl(result);
	}

	public StatsTable getStatsTable(String name) {
		final StatsTableImpl result = new StatsTableImpl(name);
		final NumberAnalyzed total = new NumberAnalyzed();
		for (Map.Entry<FileFormat, NumberAnalyzed> ent : data.entrySet()) {
			final NumberAnalyzed n = ent.getValue();
			if (n.getNb() > 0) {
				result.addLine(createLine(ent.getKey().name(), n));
				total.add(n);
			}
		}
		result.addLine(createLine("Total", total));
		return result;
	}

	public void reload(String prefix, Preferences prefs) throws BackingStoreException {
		for (String key : prefs.keys()) {
			if (key.startsWith(prefix)) {
				try {
					final String name = removeDotSaved(key);
					final NumberAnalyzed value = NumberAnalyzed.load(name, prefs);
					if (value != null) {
						final String subname = name.substring(prefix.length());
						if (subname.equals("ANIMATED_GIF"))
							continue;
						final FileFormat format = FileFormat.valueOf(subname);
						data.put(format, value);
					}
				} catch (Exception e) {
					Logme.error(e);
				}
			}
		}
	}

	static String removeDotSaved(String key) {
		return key.substring(0, key.length() - ".saved".length());
	}

	public void save(Preferences prefs, FileFormat fileFormat) {
		data.get(fileFormat).save(prefs);
	}

}
