// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.ditaa;

import java.awt.Font;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.sourceforge.plantuml.command.PSystemBasicFactory;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;

public class PSystemDitaaFactory extends PSystemBasicFactory<PSystemDitaa> {
    // ::remove folder when __HAXE__

	// private StringBuilder data;
	// // -E,--no-separation
	// private boolean performSeparationOfCommonEdges;
	//
	// // -S,--no-shadows
	// private boolean dropShadows;

	public PSystemDitaaFactory() {
		super(DiagramType.DITAA);
	}

	@Override
	public PSystemDitaa initDiagram(UmlSource source, String startLine) {
		boolean performSeparationOfCommonEdges = true;
		if (startLine != null && (startLine.contains("-E") || startLine.contains("--no-separation")))
			performSeparationOfCommonEdges = false;

		boolean dropShadows = true;
		if (startLine != null && (startLine.contains("-S") || startLine.contains("--no-shadows")))
			dropShadows = false;

		boolean allCornersAreRound = false;
		if (startLine != null && (startLine.contains("-r") || startLine.contains("--round-corners")))
			allCornersAreRound = true;

		boolean transparentBackground = false;
		if (startLine != null && (startLine.contains("-T") || startLine.contains("--transparent")))
			transparentBackground = true;

		boolean forceFontSize = false;
		if (startLine != null && startLine.contains("--font-size"))
			forceFontSize = true;

		final float scale = extractScale(startLine);
		final Font font = extractFont(startLine);

		return new PSystemDitaa(source, "", performSeparationOfCommonEdges, dropShadows, allCornersAreRound,
				transparentBackground, scale, font, forceFontSize);

	}

	@Override
	public PSystemDitaa executeLine(UmlSource source, PSystemDitaa system, String line) {
		if (system == null && (line.equals("ditaa") || line.startsWith("ditaa("))) {
			boolean performSeparationOfCommonEdges = true;
			if (line.contains("-E") || line.contains("--no-separation"))
				performSeparationOfCommonEdges = false;

			boolean dropShadows = true;
			if (line.contains("-S") || line.contains("--no-shadows"))
				dropShadows = false;

			boolean allCornersAreRound = false;
			if (line.contains("-r") || line.contains("--round-corners"))
				allCornersAreRound = true;

			boolean transparentBackground = false;
			if (line.contains("-T") || line.contains("--transparent"))
				transparentBackground = true;

			boolean forceFontSize = false;
			if (line.contains("--font-size"))
				forceFontSize = true;

			final float scale = extractScale(line);
			final Font font = extractFont(line);
			return new PSystemDitaa(source, "", performSeparationOfCommonEdges, dropShadows, allCornersAreRound,
					transparentBackground, scale, font, forceFontSize);
		}
		if (system == null)
			return null;

		return system.add(line);
	}

	private float extractScale(String line) {
		if (line == null)
			return 1;

		final Pattern p = Pattern.compile("scale=([\\d.]+)");
		final Matcher m = p.matcher(line);
		if (m.find()) {
			final String number = m.group(1);
			return Float.parseFloat(number);
		}
		return 1;
	}

	private Font extractFont(String line) {
		if (line == null)
			return new Font("Dialog", Font.BOLD, 12);

		final Pattern pName = Pattern.compile("font-family=([a-zA-Z0-0 ]+)");
		final Matcher mName = pName.matcher(line);
		String fontName = "Dialog";
		if (mName.find()) {
			fontName = mName.group(1);
		}

		final Pattern pVariant = Pattern.compile("font-variant=(BOLD|ITALIC|PLAIN)");
		final Matcher mVariant = pVariant.matcher(line);
		int fontVariant = Font.BOLD;
		if (mVariant.find()) {
			switch (mVariant.group(1)) {
			case "BOLD":
				fontVariant = Font.BOLD;
				break;
			case "ITALIC":
				fontVariant = Font.ITALIC;
				break;
			case "PLAIN":
				fontVariant = Font.PLAIN;
				break;
			}
		}

		final Pattern pSize = Pattern.compile("font-size=([\\d]+)");
		final Matcher mSize = pSize.matcher(line);
		int fontSize = 12;
		if (mSize.find()) {
			fontSize = Integer.parseInt(mSize.group(1));
		}

		return new Font(fontName, fontVariant, fontSize);
	}
}
