// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.plot;

import jcckit.graphic.ClippingShape;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.Rectangle;
import jcckit.util.ConfigParameters;

/**
 * A factory of bars. The bars are {@link Rectangle Rectangles}. 
 * Depending on the configuration parameters the bars can be 
 * horizontal or vertical. Bars of several curves can be side by side or
 * stacked. The bar length is determined by the x or y value of the 
 * curve point in device-independent coordinates. If the value is negative 
 * the bar goes into the negative direction. For stacked bars the values
 * should always be positive.
 * <p>
 * When used inside a {@link SimpleCurve} soft clipping should always be
 * switched off (see 
 * {@link SimpleCurve#SimpleCurve(ConfigParameters, int, int, ClippingShape, Legend)}). 
 *
 * @author Franz-Josef Elmer
 */
public class BarFactory extends AbstractSymbolFactory {
  /** Configuration parameter key. */
  public static final String STACKED_KEY = "stacked",
                             HORIZONTAL_BARS_KEY = "horizontalBars";

  private final boolean _stacked;
  private final boolean _horizontalBars;

  /**
   * Creates an instance from the specified configuration parameters.
   * <table border=1 cellpadding=5>
   * <tr><th>Key &amp; Default Value</th><th>Type</th><th>Mandatory</th>
   *     <th>Description</th></tr>
   * <tr><td><tt>horizontalBars = false</tt></td>
   *     <td><tt>boolean</tt></td><td>no</td>
   *     <td>If <tt>true</tt> horizontal bars will be drawn. Otherwise 
   *         vertical bars are drawn.</td></tr>
   * <tr><td><tt>stacked = false</tt></td>
   *     <td><tt>boolean</tt></td><td>no</td>
   *     <td>If <tt>true</tt> the bars of several curves will be 
   *         stacked.</td></tr>
   * </table>
   * In addition the configuration parameters of the
   * <a href="AbstractSymbolFactory.html#AbstractSymbolFactory(jcckit.util.ConfigParameters)">
   * constructor</a> of the superclass {@link AbstractSymbolFactory} apply.
   */
  public BarFactory(ConfigParameters config) {
    super(config);
    _horizontalBars = config.getBoolean(HORIZONTAL_BARS_KEY, false);
    _stacked = config.getBoolean(STACKED_KEY, false);
  }

  /**
   * Creates a bar at the specified point.
   * If <tt>hintFromPreviousCurve</tt>
   * is not an instance of {@link PositionHint} the values of 
   * origin and position will be (0,0).
   * @param hintFromPreviousCurve Hint from previous curve. Will be used
   *        to calculate symbol shape and hint for the next curve.
   */
  protected Symbol createSymbol(GraphPoint point, GraphicAttributes attributes,
                             Hint hintForNextPoint,
                             Hint hintFromPreviousCurve) {
    GraphPoint origin = new GraphPoint(null);
    GraphPoint position = origin;
    if (hintFromPreviousCurve instanceof PositionHint) {
      origin = ((PositionHint) hintFromPreviousCurve).getOrigin();
      position = ((PositionHint) hintFromPreviousCurve).getPosition();
    }
    double px = position.getX();
    double py = position.getY();
    double x = point.getX() - origin.getX();
    double y = point.getY() - origin.getY();
    if (_horizontalBars) {
      y = _size;
      position = new GraphPoint(px + 0.5 * x, point.getY() + py);
      px += _stacked ? x : 0;
      py += _stacked ? 0 : _size;
    } else {
      x = _size;
      position = new GraphPoint(point.getX() + px, py + 0.5 * y);
      px += _stacked ? 0 : _size;
      py += _stacked ? y : 0;
    }
    Hint hintForNextCurve = new PositionHint(origin, new GraphPoint(px, py));
    return new Symbol(new Rectangle(position, Math.abs(x), Math.abs(y), 
                                    attributes),
                      hintForNextPoint, hintForNextCurve);
  }

  /**
   *  Creates a symbol for the legend at the specified position.
   *  @param centerPosition Center position of the symbol.
   *  @param size The size of the symbol.
   */
  public GraphicalElement createLegendSymbol(GraphPoint centerPosition,
                                             double size) {
    return new Rectangle(centerPosition, size, size, _attributes);
  }
  
  /** 
   * Returns <tt>null</tt> because this method isn't needed but has to be
   * implemented.
   */
  protected GraphicalElement createPlainSymbol(
      GraphPoint centerPosition, double size, GraphicAttributes attributes) {
    return null;
  }
}
