// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package zext.plantuml.com.ctreber.acearth.renderer;

import zext.plantuml.com.ctreber.acearth.scanbit.BitGeneratorMap;
import zext.plantuml.com.ctreber.acearth.scanbit.ScanBit;

/**
 * <p>Renders a row of ScanBits to pixel types.</p>
 *
 * <p>&copy; 2002 Christian Treber, ct@ctreber.com (Nov 11, 2002)</p>
 * @author Christian Treber, ct@ctreber.com
 *
 */
public class RowTypeRendererScanBit implements RowTypeRenderer
{
  private int fScanBitIndex;
  private ScanBit[] fScanBits;
  private final int[] fScanToPixelType = new int[256];

  public void startNewRun()
  {
    fScanBitIndex = 0;
    generateScanToPixelTypeTable();
  }

  public void getPixelTypes(int pRowNo, int[] pPixelTypes)
  {
    // For all ScanBits in specified row...
    while((fScanBitIndex < fScanBits.length) &&
      (fScanBits[fScanBitIndex].getY() == pRowNo))
    {
      for(int i = fScanBits[fScanBitIndex].getlXFrom();
          i <= fScanBits[fScanBitIndex].getXTo(); i++)
      {
        /**
         * This is weird... why summing up the types? Note the row stays the
         * same, but it possibly gets paved over a couple of times (There
         * might be ScanBits painting on the same pixels).
         *
         * The polygons specify -1 as water and 1 as land.
         * The type table says space is 0, Water is 1 to 64, Land is 65+.
         *
         * The outline paints the whole world as water (64). Adding a
         * land pixel (1) creates a value of 65 (land). Adding a water
         * pixel (-1) changes this back to 64 (water).
         */
        pPixelTypes[i] += fScanBits[fScanBitIndex].getType();
      }
      fScanBitIndex++;
    }

    // Translate generateScanBits values into pixels types.
    for(int lCol = 0; lCol < pPixelTypes.length; lCol++)
    {
      pPixelTypes[lCol] = fScanToPixelType[pPixelTypes[lCol] & 0xff];
    }
  }

  private void generateScanToPixelTypeTable()
  {
    for(int i = 0; i < 256; i++)
    {
      if(i == 0)
      {
        // 0 is Space.
        fScanToPixelType[i] = BitGeneratorMap.PixTypeSpace;
      } else if(i > 64)
      {
        // Above 64 it's land.
        fScanToPixelType[i] = BitGeneratorMap.PixTypeLand;
      } else
      {
        // From 1 to 64 incl. it's water
        fScanToPixelType[i] = BitGeneratorMap.PixTypeWater;
      }
    }
  }

  public void setScanBits(ScanBit[] pScanBits)
  {
    fScanBits = pScanBits;
  }
}
