// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;

/**
 * 
 * @author Efstathios Sideris
 */
public class DiagramText extends DiagramComponent {

	public static final Color DEFAULT_COLOR = Color.black;
	
	private String text;
	private Font font;
	private int xPos, yPos;
	private Color color = Color.black;
	private boolean isTextOnLine = false;
	private boolean hasOutline = false;
	private Color outlineColor = Color.white;
	private final FontMeasurer fontMeasurer;

	public DiagramText(int x, int y, String text, Font font, FontMeasurer fontMeasurer){
		if(text == null) throw new IllegalArgumentException("DiagramText cannot be initialised with a null string");
		if(font == null) throw new IllegalArgumentException("DiagramText cannot be initialised with a null font");

		this.xPos = x;
		this.yPos = y;
		this.text = text;
		this.font = font;
		this.fontMeasurer = fontMeasurer;
	}

	public void centerInBounds(Rectangle2D bounds){
		centerHorizontallyBetween((int) bounds.getMinX(), (int) bounds.getMaxX());
		centerVerticallyBetween((int) bounds.getMinY(), (int) bounds.getMaxY());
	}

	public void centerHorizontallyBetween(int minX, int maxX){
		int width = fontMeasurer.getWidthFor(text, font);
		int center = Math.abs(maxX - minX) / 2;
		xPos += Math.abs(center - width / 2);
		
	}

	public void centerVerticallyBetween(int minY, int maxY){
		int zHeight = fontMeasurer.getZHeight(font);
		int center = Math.abs(maxY - minY) / 2;
		yPos -= Math.abs(center - zHeight / 2);
	}

	public void alignRightEdgeTo(int x){
		int width = fontMeasurer.getWidthFor(text, font);
		xPos = x - width;
	}


	/**
	 * @return
	 */
	public Color getColor() {
		return color;
	}

	/**
	 * @return
	 */
	public Font getFont() {
		return font;
	}

	/**
	 * @return
	 */
	public String getText() {
		return text;
	}

	/**
	 * @return
	 */
	public int getXPos() {
		return xPos;
	}

	/**
	 * @return
	 */
	public int getYPos() {
		return yPos;
	}

	/**
	 * @param color
	 */
	public void setColor(Color color) {
		this.color = color;
	}

	/**
	 * @param font
	 */
	public void setFont(Font font) {
		this.font = font;
	}

	/**
	 * @param string
	 */
	public void setText(String string) {
		text = string;
	}

	/**
	 * @param i
	 */
	public void setXPos(int i) {
		xPos = i;
	}

	/**
	 * @param i
	 */
	public void setYPos(int i) {
		yPos = i;
	}

	public Rectangle2D getBounds(){
		Rectangle2D bounds = fontMeasurer.getBoundsFor(text, font);
		bounds.setRect(
			bounds.getMinX() + xPos,
			bounds.getMinY() + yPos,
			bounds.getWidth(),
			bounds.getHeight());
		return bounds;
	}
	
	public String toString(){
		return "DiagramText, at ("+xPos+", "+yPos+"), within "+getBounds()+" '"+text+"', "+color+" "+font;
	}

	/**
	 * @return
	 */
	public boolean isTextOnLine() {
		return isTextOnLine;
	}

	/**
	 * @param b
	 */
	public void setTextOnLine(boolean b) {
		isTextOnLine = b;
	}

	public boolean hasOutline() {
		return hasOutline;
	}

	public void setHasOutline(boolean hasOutline) {
		this.hasOutline = hasOutline;
	}

	public Color getOutlineColor() {
		return outlineColor;
	}

	public void setOutlineColor(Color outlineColor) {
		this.outlineColor = outlineColor;
	}

	
}
