// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.json;

import java.io.IOException;
import java.io.Reader;

/**
 * This class serves as the entry point to the minimal-json API.
 * <p>
 * To <strong>parse</strong> a given JSON input, use the <code>parse()</code>
 * methods like in this example:
 * </p>
 * 
 * <pre>
 * JsonObject object = Json.parse(string).asObject();
 * </pre>
 * <p>
 * To <strong>create</strong> a JSON data structure to be serialized, use the
 * methods <code>value()</code>, <code>array()</code>, and
 * <code>object()</code>. For example, the following snippet will produce the
 * JSON string <em>{"foo": 23, "bar": true}</em>:
 * </p>
 * 
 * <pre>
 * String string = Json.object().add("foo", 23).add("bar", true).toString();
 * </pre>
 * <p>
 * To create a JSON array from a given Java array, you can use one of the
 * <code>array()</code> methods with varargs parameters:
 * </p>
 * 
 * <pre>
 * String[] names = ...
 * JsonArray array = Json.array(names);
 * </pre>
 */
public final class Json {

	private Json() {
		// not meant to be instantiated
	}

	/**
	 * Represents the JSON literal <code>null</code>.
	 */
	public static final JsonValue NULL = new JsonLiteral("null");

	/**
	 * Represents the JSON literal <code>true</code>.
	 */
	public static final JsonValue TRUE = new JsonLiteral("true");

	/**
	 * Represents the JSON literal <code>false</code>.
	 */
	public static final JsonValue FALSE = new JsonLiteral("false");

	/**
	 * Returns a JsonValue instance that represents the given <code>int</code>
	 * value.
	 *
	 * @param value the value to get a JSON representation for
	 * @return a JSON value that represents the given value
	 */
	public static JsonValue value(int value) {
		return new JsonNumber(Integer.toString(value, 10));
	}

	/**
	 * Returns a JsonValue instance that represents the given <code>long</code>
	 * value.
	 *
	 * @param value the value to get a JSON representation for
	 * @return a JSON value that represents the given value
	 */
	public static JsonValue value(long value) {
		return new JsonNumber(Long.toString(value, 10));
	}

	/**
	 * Returns a JsonValue instance that represents the given <code>float</code>
	 * value.
	 *
	 * @param value the value to get a JSON representation for
	 * @return a JSON value that represents the given value
	 */
	public static JsonValue value(float value) {
		if (Float.isInfinite(value) || Float.isNaN(value)) {
			throw new IllegalArgumentException("Infinite and NaN values not permitted in JSON");
		}
		return new JsonNumber(cutOffPointZero(Float.toString(value)));
	}

	/**
	 * Returns a JsonValue instance that represents the given <code>double</code>
	 * value.
	 *
	 * @param value the value to get a JSON representation for
	 * @return a JSON value that represents the given value
	 */
	public static JsonValue value(double value) {
		if (Double.isInfinite(value) || Double.isNaN(value)) {
			throw new IllegalArgumentException("Infinite and NaN values not permitted in JSON");
		}
		return new JsonNumber(cutOffPointZero(Double.toString(value)));
	}

	/**
	 * Returns a JsonValue instance that represents the given string.
	 *
	 * @param string the string to get a JSON representation for
	 * @return a JSON value that represents the given string
	 */
	public static JsonValue value(String string) {
		return string == null ? NULL : new JsonString(string);
	}

	/**
	 * Returns a JsonValue instance that represents the given <code>boolean</code>
	 * value.
	 *
	 * @param value the value to get a JSON representation for
	 * @return a JSON value that represents the given value
	 */
	public static JsonValue value(boolean value) {
		return value ? TRUE : FALSE;
	}

	/**
	 * Creates a new empty JsonArray. This is equivalent to creating a new JsonArray
	 * using the constructor.
	 *
	 * @return a new empty JSON array
	 */
	public static JsonArray array() {
		return new JsonArray();
	}

	/**
	 * Creates a new JsonArray that contains the JSON representations of the given
	 * <code>int</code> values.
	 *
	 * @param values the values to be included in the new JSON array
	 * @return a new JSON array that contains the given values
	 */
	public static JsonArray array(int... values) {
		if (values == null) {
			throw new NullPointerException("values is null");
		}
		JsonArray array = new JsonArray();
		for (int value : values) {
			array.add(value);
		}
		return array;
	}

	/**
	 * Creates a new JsonArray that contains the JSON representations of the given
	 * <code>long</code> values.
	 *
	 * @param values the values to be included in the new JSON array
	 * @return a new JSON array that contains the given values
	 */
	public static JsonArray array(long... values) {
		if (values == null) {
			throw new NullPointerException("values is null");
		}
		JsonArray array = new JsonArray();
		for (long value : values) {
			array.add(value);
		}
		return array;
	}

	/**
	 * Creates a new JsonArray that contains the JSON representations of the given
	 * <code>float</code> values.
	 *
	 * @param values the values to be included in the new JSON array
	 * @return a new JSON array that contains the given values
	 */
	public static JsonArray array(float... values) {
		if (values == null) {
			throw new NullPointerException("values is null");
		}
		JsonArray array = new JsonArray();
		for (float value : values) {
			array.add(value);
		}
		return array;
	}

	/**
	 * Creates a new JsonArray that contains the JSON representations of the given
	 * <code>double</code> values.
	 *
	 * @param values the values to be included in the new JSON array
	 * @return a new JSON array that contains the given values
	 */
	public static JsonArray array(double... values) {
		if (values == null) {
			throw new NullPointerException("values is null");
		}
		JsonArray array = new JsonArray();
		for (double value : values) {
			array.add(value);
		}
		return array;
	}

	/**
	 * Creates a new JsonArray that contains the JSON representations of the given
	 * <code>boolean</code> values.
	 *
	 * @param values the values to be included in the new JSON array
	 * @return a new JSON array that contains the given values
	 */
	public static JsonArray array(boolean... values) {
		if (values == null) {
			throw new NullPointerException("values is null");
		}
		JsonArray array = new JsonArray();
		for (boolean value : values) {
			array.add(value);
		}
		return array;
	}

	/**
	 * Creates a new JsonArray that contains the JSON representations of the given
	 * strings.
	 *
	 * @param strings the strings to be included in the new JSON array
	 * @return a new JSON array that contains the given strings
	 */
	public static JsonArray array(String... strings) {
		if (strings == null) {
			throw new NullPointerException("values is null");
		}
		JsonArray array = new JsonArray();
		for (String value : strings) {
			array.add(value);
		}
		return array;
	}

	/**
	 * Creates a new empty JsonObject. This is equivalent to creating a new
	 * JsonObject using the constructor.
	 *
	 * @return a new empty JSON object
	 */
	public static JsonObject object() {
		return new JsonObject();
	}

	/**
	 * Parses the given input string as JSON. The input must contain a valid JSON
	 * value, optionally padded with whitespace.
	 *
	 * @param string the input string, must be valid JSON
	 * @return a value that represents the parsed JSON
	 * @throws ParseException if the input is not valid JSON
	 */
	public static JsonValue parse(String string) {
		if (string == null) {
			throw new NullPointerException("string is null");
		}
		DefaultHandler handler = new DefaultHandler();
		new JsonParser(handler).parse(string);
		return handler.getValue();
	}

	/**
	 * Reads the entire input from the given reader and parses it as JSON. The input
	 * must contain a valid JSON value, optionally padded with whitespace.
	 * <p>
	 * Characters are read in chunks into an input buffer. Hence, wrapping a reader
	 * in an additional <code>BufferedReader</code> likely won't improve reading
	 * performance.
	 * </p>
	 *
	 * @param reader the reader to read the JSON value from
	 * @return a value that represents the parsed JSON
	 * @throws IOException    if an I/O error occurs in the reader
	 * @throws ParseException if the input is not valid JSON
	 */
	public static JsonValue parse(Reader reader) throws IOException {
		if (reader == null) {
			throw new NullPointerException("reader is null");
		}
		DefaultHandler handler = new DefaultHandler();
		new JsonParser(handler).parse(reader);
		return handler.getValue();
	}

	private static String cutOffPointZero(String string) {
		if (string.endsWith(".0")) {
			return string.substring(0, string.length() - 2);
		}
		return string;
	}

	public static class DefaultHandler extends JsonHandler<JsonArray, JsonObject> {

		protected JsonValue value;

		@Override
		public JsonArray startArray() {
			return new JsonArray();
		}

		@Override
		public JsonObject startObject() {
			return new JsonObject();
		}

		@Override
		public void endNull() {
			value = NULL;
		}

		@Override
		public void endBoolean(boolean bool) {
			value = bool ? TRUE : FALSE;
		}

		@Override
		public void endString(String string) {
			value = new JsonString(string);
		}

		@Override
		public void endNumber(String string) {
			value = new JsonNumber(string);
		}

		@Override
		public void endArray(JsonArray array) {
			value = array;
		}

		@Override
		public void endObject(JsonObject object) {
			value = object;
		}

		@Override
		public void endArrayValue(JsonArray array) {
			array.add(value);
		}

		@Override
		public void endObjectValue(JsonObject object, String name) {
			object.add(name, value);
		}

		public JsonValue getValue() {
			return value;
		}

	}

}
