// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.elk.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

import net.sourceforge.plantuml.log.Logme;

/*
 * Various methods to do Java introspection
 */
public class Reflect {

	public static Class clazz(String className) {
		try {
			return Class.forName(className);
		} catch (Throwable t) {
			Logme.error(t);
			throw new IllegalArgumentException(t);
		}
	}

	public static Enum getEnum(String clazz, String name) {
		try {
			final Class cl = clazz(clazz);
			for (Object en : cl.getEnumConstants()) {
				if (en.toString().equals(name)) {
					return (Enum) en;
				}
			}
			throw new UnsupportedOperationException(name);
		} catch (Throwable t) {
			Logme.error(t);
			throw new IllegalArgumentException(t);
		}
	}

	public static Object opt(String className, String fieldname) {
		try {
			final Class<?> cl = Class.forName(className);
			final Field field = cl.getField(fieldname);
			return field.get(null);
		} catch (Throwable t) {
			Logme.error(t);
			throw new IllegalArgumentException(t);
		}
	}

	public static Object newInstance(String className) {
		try {
			final Class<?> cl = Class.forName(className);
			return cl.newInstance();
		} catch (Throwable t) {
			Logme.error(t);
			throw new IllegalArgumentException(t);
		}
	}

	public static Object newInstance(String className, Object arg1) {
		try {
			final Class<?> cl = Class.forName(className);
			final Constructor<?> m = cl.getConstructor(arg1.getClass());
			return m.newInstance(arg1);
		} catch (Throwable t) {
			Logme.error(t);
			throw new IllegalArgumentException(t);
		}
	}

	public static Object newInstance(String className, double arg1, double arg2, double arg3, double arg4) {
		try {
			final Class<?> cl = Class.forName(className);
			final Constructor<?> m = cl.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
			return m.newInstance(arg1, arg2, arg3, arg4);
		} catch (Throwable t) {
			Logme.error(t);
			throw new IllegalArgumentException(t);
		}
	}

	public static Object field(String className, String fieldName) {
		try {
			final Class<?> cl = Class.forName(className);
			final Field f = cl.getField(fieldName);
			return f.get(null);
		} catch (Throwable t) {
			Logme.error(t);
			throw new IllegalArgumentException(t);
		}
	}

	public static Object callStatic(String className, String method) {
		try {
			final Class<?> cl = Class.forName(className);
			final Method m = cl.getMethod(method);
			return m.invoke(null);
		} catch (Throwable t) {
			Logme.error(t);
			throw new IllegalArgumentException(t);
		}
	}

	public static Object callStatic(String className, String method, Object arg1) {
		try {
			final Class<?> cl = Class.forName(className);
			final Method m = cl.getMethod(method, arg1.getClass());
			return m.invoke(null, arg1);
		} catch (Throwable t) {
			Logme.error(t);
			throw new IllegalArgumentException(t);
		}
	}

	public static Object callStatic(String className, String method, Object arg1, Object arg2) {
		try {
			final Class<?> cl = Class.forName(className);
			final Method m = cl.getMethod(method, arg1.getClass(), arg2.getClass());
			return m.invoke(null, arg1, arg2);
		} catch (Throwable t) {
			Logme.error(t);
			throw new IllegalArgumentException(t);
		}
	}

	public static Object callStatic2(String className, String method, Object arg1) {
		try {
			final Class<?> cl = Class.forName(className);
			final Method m = getStaticMethod(cl, method, 1);
			return m.invoke(null, arg1);
		} catch (Throwable t) {
			Logme.error(t);
			throw new IllegalArgumentException(t);
		}
	}

	public static Object callStatic2(String className, String method, Object arg1, Object arg2) {
		try {
			final Class<?> cl = Class.forName(className);
			final Method m = getStaticMethod(cl, method, 2);
			return m.invoke(null, arg1, arg2);
		} catch (Throwable t) {
			Logme.error(t);
			throw new IllegalArgumentException(t);
		}
	}

	public static Method getStaticMethod(Class<?> cl, String method, int nbArgs) {
		for (Method m : cl.getMethods()) {
			if (m.getName().equals(method) && m.getParameters().length == nbArgs) {
				return m;
			}
		}
		throw new IllegalArgumentException();
	}

	public static Object call(Object instance, String method) {
		try {
			final Method m = instance.getClass().getMethod(method);
			return m.invoke(instance);
		} catch (Throwable t) {
			Logme.error(t);
			throw new IllegalArgumentException(t);
		}
	}

	public static Object call(Object instance, String method, Object arg1) {
		try {
			final Method m = instance.getClass().getMethod(method, arg1.getClass());
			return m.invoke(instance, arg1);
		} catch (Throwable t) {
			Logme.error(t);
			throw new IllegalArgumentException(t);
		}
	}

	public static Object call(Object instance, String method, Object arg1, Object arg2) {
		try {
			final Method m = instance.getClass().getMethod(method, arg1.getClass(), arg2.getClass());
			return m.invoke(instance, arg1, arg2);
		} catch (Throwable t) {
			Logme.error(t);
			throw new IllegalArgumentException(t);
		}
	}

	public static Object call2(Object instance, String method, Object arg1, Object arg2) {
		try {
			final Method m = getMethod(instance, method, 2);
			return m.invoke(instance, arg1, arg2);
		} catch (Throwable t) {
			Logme.error(t);
			throw new IllegalArgumentException(t);
		}
	}

	public static Method getMethod(Object instance, String method, int nbArgs) {
		for (Method m : instance.getClass().getMethods()) {
			if (m.getName().equals(method) && m.getParameters().length == nbArgs) {
				return m;
			}
		}
		throw new IllegalArgumentException();
	}

}
