// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.graphic;

import java.util.Hashtable;

import jcckit.util.ConfigParameters;
import jcckit.util.FactoryException;

/**
 *  Font style constants.
 *  This class is based on the typesafe enumeration pattern.
 *
 *  @author Franz-Josef Elmer
 */
public class FontStyle {
  private static final Hashtable REPOSITORY = new Hashtable();
  static final String NORMAL_TXT = "normal",
                      BOLD_TXT = "bold",
                      ITALIC_TXT = "italic",
                      BOLD_ITALIC_TXT = "bold italic";
  /** Font style constant. */
  public static final FontStyle NORMAL = new FontStyle(NORMAL_TXT),
                                BOLD = new FontStyle(BOLD_TXT),
                                ITALIC = new FontStyle(ITALIC_TXT),
                                BOLD_ITALIC = new FontStyle(BOLD_ITALIC_TXT);

  private final String _description;

  /** Non-public constructor to control the number of instances. */
  private FontStyle(String description) {
    _description = description;
    REPOSITORY.put(description, this);
  }

  /**
   *  Returns from the specified configuration parameters the font style
   *  defined by the specified key or the specified default value.
   *  @param config Configuration parameters.
   *  @param key The key of the font style.
   *  @param defaultValue The default value.
   *  @return one of the four instances of <tt>FontStyle</tt>.
   *  @throws FactoryException if the value of the key-value pair denoted
   *          by <tt>key</tt> is neither <tt>normal</tt>, <tt>bold</tt>, 
   *          <tt>italic</tt>, nor <tt>bold italic</tt>,
   *          Note, that {@link FactoryException#getClassName()} 
   *          returns the invalid value.
   */
  public static FontStyle getFontStyle(ConfigParameters config, String key,
                                       FontStyle defaultValue) {
    FontStyle result = defaultValue;
    String value = config.get(key, null);
    if (value != null) {
      result = (FontStyle) REPOSITORY.get(value);
      if (result == null) {
        throw new FactoryException(config, key, "Invalid font style.");
      }
    }
    return result;
  }

  /** Returns a human readable description for pretty printing. */
  public String toString() {
    return _description;
  }
}
