// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.webp;

import java.io.IOException;

import javax.imageio.stream.ImageInputStream;

public class BoolDecoder {
    // ::remove folder when __HAXE__
	// ::remove folder when __CORE__
    // ::remove folder when __MIT__ or __EPL__ or __BSD__ or __ASL__ or __LGPL__
	int bit_count; /* # of bits shifted out of value, at most 7 */
	ImageInputStream data;
	private long offset; /* pointer to next compressed data byte */
	private int range; /* always identical to encoder's range */
	private int value; /* contains at least 24 significant bits */

	BoolDecoder(ImageInputStream frame, long offset) throws IOException {
		this.data = frame;
		this.offset = offset;
		initBoolDecoder();
	}

	private void initBoolDecoder() throws IOException {

		value = 0; /* value = first 16 input bits */

		data.seek(offset);
		value = data.readUnsignedByte() << 8;
		// value = (data[offset]) << 8;
		offset++;

		range = 255; /* initial range is full */
		bit_count = 0; /* have not yet shifted out any bits */
	}

	public int readBit() throws IOException {
		return readBool(128);
	}

	public int readBool(int probability) throws IOException {

		int bit = 0;
		int split;
		int bigsplit;
		int range = this.range;
		int value = this.value;
		split = 1 + (((range - 1) * probability) >> 8);
		bigsplit = (split << 8);
		range = split;

		if (value >= bigsplit) {
			range = this.range - split;
			value = value - bigsplit;
			bit = 1;
		}

		{
			int count = this.bit_count;
			int shift = Globals.vp8dxBitreaderNorm[range];
			range <<= shift;
			value <<= shift;
			count -= shift;

			if (count <= 0) {
				// data.seek(offset);
				value |= data.readUnsignedByte() << (-count);
				// value |= data[offset] << (-count);
				offset++;
				count += 8;
			}

			this.bit_count = count;
		}
		this.value = value;
		this.range = range;
		return bit;
	}

	/*
	 * Convenience function reads a "literal", that is, a "num_bits" wide unsigned
	 * value whose bits come high- to low-order, with each bit encoded at
	 * probability 128 (i.e., 1/2).
	 */
	public int readLiteral(int num_bits) throws IOException {
		int v = 0;
		while (num_bits-- > 0)
			v = (v << 1) + readBool(128);
		return v;
	}

	int readTree(int t[], /* tree specification */
			int p[] /* corresponding interior node probabilities */
	) throws IOException {
		int i = 0; /* begin at root */

		/* Descend tree until leaf is reached */
		while ((i = t[i + readBool(p[i >> 1])]) > 0) {
		}
		return -i; /* return value is negation of nonpositive index */

	}

	int readTreeSkip(int t[], /* tree specification */
			int p[], /* corresponding interior node probabilities */
			int skip_branches) throws IOException {
		int i = skip_branches * 2; /* begin at root */

		/* Descend tree until leaf is reached */
		while ((i = t[i + readBool(p[i >> 1])]) > 0) {
		}
		return -i; /* return value is negation of nonpositive index */

	}

	public void seek() throws IOException {
		data.seek(offset);
	}

	public String toString() {
		return "bc: " + value;
	}

}
