// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.LineParam;
import net.sourceforge.plantuml.skin.rose.AbstractComponentRoseArrow;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ISkinParam;

public class CommunicationTile extends AbstractTile {

	private final LivingSpace livingSpace1;
	private final LivingSpace livingSpace2;
	private final LivingSpaces livingSpaces;
	private final Message message;
	private final Rose skin;
	private final ISkinParam skinParam;
	private final YGauge yGauge;

	public Event getEvent() {
		return message;
	}

	@Override
	public String toString() {
		return super.toString() + " " + message;
	}

	public CommunicationTile(StringBounder stringBounder, LivingSpaces livingSpaces, Message message, Rose skin,
			ISkinParam skinParam, YGauge currentY) {
		super(stringBounder, currentY);
		this.livingSpace1 = livingSpaces.get(message.getParticipant1());
		this.livingSpace2 = livingSpaces.get(message.getParticipant2());
		this.livingSpaces = livingSpaces;
		this.message = message;
		this.skin = skin;
		this.skinParam = skinParam;

		if (message.isCreate())
			livingSpace2.goCreate();

		final ArrowComponent comp = getComponent(getStringBounder());
		final XDimension2D dim = comp.getPreferredDimension(getStringBounder());

		if (message.isParallel())
			this.yGauge = YGauge.create(currentY.getMin(), dim.getHeight());
		else
			this.yGauge = YGauge.create(currentY.getMax(), dim.getHeight());
	}

	@Override
	public YGauge getYGauge() {
		return yGauge;
	}

	public boolean isReverse(StringBounder stringBounder) {
		final Real point1 = livingSpace1.getPosC(stringBounder);
		final Real point2 = livingSpace2.getPosC(stringBounder);
		if (point1.getCurrentValue() > point2.getCurrentValue())
			return true;

		return false;
	}

	private boolean isCreate() {
		return message.isCreate();
	}

	private double getArrowThickness() {
		final UStroke result = skinParam.getThickness(LineParam.sequenceArrow, null);
		if (result == null)
			return 1;

		return result.getThickness();
	}

	private ArrowComponent getComponent(StringBounder stringBounder) {
		ArrowConfiguration arrowConfiguration = message.getArrowConfiguration();
		if (isReverse(stringBounder))
			arrowConfiguration = arrowConfiguration.reverse();

		arrowConfiguration = arrowConfiguration.withThickness(getArrowThickness());

		return skin.createComponentArrow(message.getUsedStyles(), arrowConfiguration, skinParam,
				message.getLabelNumbered());
	}

	private ArrowComponent getComponentMulticast(StringBounder stringBounder, boolean reverse) {
		ArrowConfiguration arrowConfiguration = message.getArrowConfiguration();
		if (reverse)
			arrowConfiguration = arrowConfiguration.reverse();

		arrowConfiguration = arrowConfiguration.withThickness(getArrowThickness());

		return skin.createComponentArrow(message.getUsedStyles(), arrowConfiguration, skinParam, Display.NULL);
	}

	@Override
	public double getContactPointRelative() {
		return getComponent(getStringBounder()).getYPoint(getStringBounder());
	}

	public static final double LIVE_DELTA_SIZE = 5;

	@Override
	final protected void callbackY_internal(TimeHook y) {
		super.callbackY_internal(y);
		if (message.isCreate())
			livingSpace2.goCreate(y.getValue());

		final AbstractComponentRoseArrow comp = (AbstractComponentRoseArrow) getComponent(getStringBounder());
		final XDimension2D dim = comp.getPreferredDimension(getStringBounder());

		final double arrowY = comp.getStartPoint(getStringBounder(), dim).getY();

		livingSpace1.addStepForLivebox(getEvent(), y.getValue() + arrowY);
		livingSpace2.addStepForLivebox(getEvent(), y.getValue() + arrowY);
	}

	public void drawU(UGraphic ug) {
		if (YGauge.USE_ME)
			ug = ug.apply(UTranslate.dy(getYGauge().getMin().getCurrentValue()));
		final String anchor1 = message.getPart1Anchor();
		final String anchor2 = message.getPart2Anchor();
		if (anchor1 != null || anchor2 != null)
			return;

		final StringBounder stringBounder = ug.getStringBounder();
		final ArrowComponent comp = getComponent(stringBounder);
		final XDimension2D dim = comp.getPreferredDimension(stringBounder);
		double x1 = getPoint1(stringBounder).getCurrentValue();
		double x2 = getPoint2(stringBounder).getCurrentValue();
		drawMulticast(ug.apply(UTranslate.dy(comp.getPosArrow(stringBounder))));

		final Area area;
		if (isReverse(stringBounder)) {
			final int level1 = livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
			final int level2 = livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
			if (level1 > 0)
				x1 -= LIVE_DELTA_SIZE;

			x2 += LIVE_DELTA_SIZE * level2;
			area = Area.create(x1 - x2, dim.getHeight());
			ug = ug.apply(UTranslate.dx(x2));
			if (isCreate())
				livingSpace2.drawHead(ug, (Context2D) ug, VerticalAlignment.TOP, HorizontalAlignment.RIGHT);

		} else {
			final int level1 = livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
			int level2 = livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
			if (level2 > 0)
				level2 = level2 - 2;

			x1 += LIVE_DELTA_SIZE * level1;
			x2 += LIVE_DELTA_SIZE * level2;
			area = Area.create(x2 - x1, dim.getHeight());
			ug = ug.apply(UTranslate.dx(x1));
			if (isCreate())
				livingSpace2.drawHead(ug.apply(UTranslate.dx(area.getDimensionToUse().getWidth())), (Context2D) ug,
						VerticalAlignment.TOP, HorizontalAlignment.LEFT);

		}
		comp.drawU(ug, area, (Context2D) ug);
	}

	private void drawMulticast(final UGraphic ug) {
		if (message.getMulticast().size() == 0)
			return;

		final StringBounder stringBounder = ug.getStringBounder();

		final double x1 = getPoint1(stringBounder).getCurrentValue();
		double dy = 2;
		for (Participant participant : message.getMulticast()) {
			final double x2 = livingSpaces.get(participant).getPosC(stringBounder).getCurrentValue();
			final boolean reverse = x2 < x1;
			final ArrowComponent comp = getComponentMulticast(stringBounder, reverse);
			final XDimension2D dim = comp.getPreferredDimension(stringBounder);
			final Area area = Area.create(Math.abs(x2 - x1), dim.getHeight());
			final UGraphic ug2 = ug.apply(UTranslate.dx(Math.min(x1, x2))).apply(UTranslate.dy(dy));
			dy += 2;
			comp.drawU(ug2, area, (Context2D) ug2);
		}

	}

	public double getPreferredHeight() {
		final Component comp = getComponent(getStringBounder());
		final XDimension2D dim = comp.getPreferredDimension(getStringBounder());
		double height = dim.getHeight();
		if (isCreate())
			height = Math.max(height, livingSpace2.getHeadPreferredDimension(getStringBounder()).getHeight());

		return height;
	}

	public void addConstraints() {
		final Component comp = getComponent(getStringBounder());
		final XDimension2D dim = comp.getPreferredDimension(getStringBounder());
		final double width = dim.getWidth();

		Real point1 = getPoint1(getStringBounder());
		Real point2 = getPoint2(getStringBounder());
		if (isReverse(getStringBounder())) {
			final int level1 = livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
			final int level2 = livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
			if (level1 > 0)
				point1 = point1.addFixed(-LIVE_DELTA_SIZE);

			point2 = point2.addFixed(level2 * LIVE_DELTA_SIZE);
			point1.ensureBiggerThan(point2.addFixed(width));
		} else {
			final int level2 = livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
			if (level2 > 0)
				point2 = point2.addFixed(-LIVE_DELTA_SIZE);

			point2.ensureBiggerThan(point1.addFixed(width));
		}
	}

	private Real getPoint1(final StringBounder stringBounder) {
		return livingSpace1.getPosC(stringBounder);
	}

	private Real getPoint2(final StringBounder stringBounder) {
		if (message.isCreate()) {
			if (isReverse(stringBounder))
				return livingSpace2.getPosD(stringBounder);

			return livingSpace2.getPosB(stringBounder);
		}
		return livingSpace2.getPosC(stringBounder);
	}

	public Real getMinX() {
		if (isReverse(getStringBounder()))
			return getPoint2(getStringBounder());

		return getPoint1(getStringBounder());
	}

	public Real getMaxX() {
		if (isReverse(getStringBounder()))
			return getPoint1(getStringBounder());

		return getPoint2(getStringBounder());
	}

}
