// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package zext.plantuml.com.ctreber.acearth.util;

import java.io.IOException;
import java.io.Writer;

/**
 * <p>
 * Latitude and longitude coordinate. Can be used as declination and right
 * ascension as well.
 * 
 * <p>
 * &copy; 2002 Christian Treber, ct@ctreber.com
 * 
 * @author Christian Treber, ct@ctreber.com
 * 
 */
public class Coordinate {
	/*
	 * MeanObliquity gives the mean obliquity of the earth's axis at epoch
	 * 1990.0 (computed as 23.440592 degrees according to the method given in
	 * duffett-smith, section 27)
	 */
	private static final double MEAN_OBLIQUITY = 23.440592 * Toolkit.TWOPI / 360;

	// Or DE
	private double fLat;
	// Or RA
	private double fLong;

	public Coordinate() {
	}

	/**
	 * <p>
	 * Construct a location specfied by two angles. Your choice if in degrees or
	 * rads, but keep track!
	 * 
	 * @param pLong
	 *            Longitude or RA
	 * @param pLat
	 *            Latitude or DE
	 */
	public Coordinate(double pLat, double pLong) {
		fLat = pLat;
		fLong = pLong;
	}

	public void renderAsXML(Writer writer) throws IOException {
		writer.write("<Coordinate>\n");
		writer.write("  <latitude>" + fLat + "</latitude>\n");
		writer.write("  <longitude>" + fLong + "</longitude>\n");
		writer.write("</Coordinate>\n");
	}

	public Point3D getPoint3D() {
		final double lLatRad = Toolkit.degsToRads(fLat);
		final double lLongRad = Toolkit.degsToRads(fLong);

		final double lX = Math.cos(lLatRad) * Math.sin(lLongRad);
		final double lY = Math.sin(lLatRad);
		final double lZ = Math.cos(lLatRad) * Math.cos(lLongRad);

		return new Point3D(lX, lY, lZ);
	}

	/**
	 * <p>
	 * Assumes coordinate is not in degrees but rads.
	 * 
	 * @return
	 */
	public Point3D getPoint3DRads() {
		final double lX = Math.cos(fLat) * Math.sin(fLong);
		final double lY = Math.sin(fLat);
		final double lZ = Math.cos(fLat) * Math.cos(fLong);

		return new Point3D(lX, lY, lZ);
	}

	/**
	 * <p>
	 * Convert from ecliptic to equatorial coordinates (after duffett-smith,
	 * section 27)
	 */
	public Coordinate eclipticToEquatorial() {
		final double sin_e = Math.sin(MEAN_OBLIQUITY);
		final double cos_e = Math.cos(MEAN_OBLIQUITY);

		final double lRA = Math.atan2(Math.sin(fLong) * cos_e - Math.tan(fLat) * sin_e, Math.cos(fLong));
		final double lDE = Math.asin(Math.sin(fLat) * cos_e + Math.cos(fLat) * sin_e * Math.sin(fLong));

		return new Coordinate(lDE, lRA);
	}

	/**
	 * <p>
	 * Add position to this position, make sure coordinates are valid.
	 */
	public void add(Coordinate lOther) {
		fLat += lOther.fLat;
		fLong += lOther.fLong;
		wrap();
	}

	/**
	 * <p>
	 * Warp coordinates exceeding valid values. Happens when latitudes and
	 * longitudes are added or substracted.
	 */
	public void wrap() {
		if (fLat > 90) {
			fLat = 180 - fLat;
			fLong += 180;
		} else if (fLat < -90) {
			fLat = -180 - fLat;
			fLong += 180;
		}

		if (fLong > 180) {
			do {
				fLong -= 360;
			} while (fLong > 180);
		} else if (fLong < -180) {
			do {
				fLong += 360;
			} while (fLong < -180);
		}
	}

	public double getLat() {
		return fLat;
	}

	public double getDE() {
		return fLat;
	}

	public double getLong() {
		return fLong;
	}

	public double getRA() {
		return fLong;
	}

	public boolean check() {
		return (-90 <= fLat) && (fLat <= 90) && (-180 <= fLong) && (fLong <= 180);
	}

	public String toString() {
		return "lat: " + fLat + ", long: " + fLong;
	}
}
