// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.plot;

import java.awt.Color;

import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.ShapeAttributes;
import jcckit.util.ConfigParameters;

/**
 * An {@link AttributesHint} which wraps {@link ShapeAttributes}.
 * Each call of {@link #getNextHint()} returns a new instance of
 * <tt>ShapeAttributes</tt> where fill color, line color and/or 
 * line thickness has been increased by a constant amount.
 * 
 * @author Franz-Josef Elmer
 */
public class ShapeAttributesHint implements AttributesHint, Cloneable {
  /** Configuration parameter key. */
  public static final String INITIAL_ATTRIBUTES_KEY = "initialAttributes",
                             FILL_COLOR_HSB_INCREMENT_KEY 
                                            = "fillColorHSBIncrement",
                             LINE_COLOR_HSB_INCREMENT_KEY 
                                            = "lineColorHSBIncrement",
                             LINE_THICKNESS_INCREMENT_KEY 
                                            = "lineThicknessIncrement";
  private static float[] extractHSB(Color color) {
    return color == null ? null 
        : Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), 
                         null);
  }
  
  private static Color createColor(float[] colorHSB) {
    return colorHSB == null ? null 
        : Color.getHSBColor(colorHSB[0], colorHSB[1], colorHSB[2]);
  }

  private static float[] incrementColor(float[] colorHSB, 
                                        double[] increments) {
    float[] result = null;
    if (colorHSB != null) {
      result = (float[]) colorHSB.clone();
      for (int i = 0; i < 3; i++) {
        result[i] += increments[i];
      }
    }
    return result;
  }

  private float[] _fillColorHSB;
  private float[] _lineColorHSB;
  private double _lineThickness;
  private double[] _linePattern;
  private double[] _fillColorHSBIncrement;
  private double[] _lineColorHSBIncrement;
  private double _lineThicknessIncrement;

  /**
   * Creates an instance from the specified configuration parameters.
   * <table border=1 cellpadding=5>
   * <tr><th>Key &amp; Default Value</th><th>Type</th><th>Mandatory</th>
   *     <th>Description</th></tr>
   * <tr><td><tt>initialAttributes = </tt><i>default values of
   *         {@link ShapeAttributes}</i></td>
   *     <td><tt>ConfigParameters</tt></td><td>no</td>
   *     <td>Initial values of shape attributes. Note, that default
   *         fill and line colors are undefined (they depend on the
   *         <tt>Renderer</tt>). In this case color increments have no effects.
   *         </td></tr>
   * <tr><td><tt>fillColorHSBIncrement = 0 0 0</tt></td>
   *     <td><tt>double[]</tt></td><td>no</td>
   *     <td>Hue, saturation, and brightness increments of the fill color.
   *         </td></tr>
   * <tr><td><tt>lineColorHSBIncrement = 0 0 0</tt></td>
   *     <td><tt>double[]</tt></td><td>no</td>
   *     <td>Hue, saturation, and brightness increments of the line color.
   *         </td></tr>
   * <tr><td><tt>lineThicknessIncrement = 0</tt></td>
   *     <td><tt>double</tt></td><td>no</td>
   *     <td>Line thickness increment.</td></tr>
   * </table>
   */
  public ShapeAttributesHint(ConfigParameters config) {
    ShapeAttributes attributes 
        = new ShapeAttributes(config.getNode(INITIAL_ATTRIBUTES_KEY));
    _fillColorHSB = extractHSB(attributes.getFillColor());
    _lineColorHSB = extractHSB(attributes.getLineColor());
    _lineThickness = attributes.getLineThickness();
    _linePattern = attributes.getLinePattern();
    
    _fillColorHSBIncrement 
          = config.getDoubleArray(FILL_COLOR_HSB_INCREMENT_KEY, new double[3]);
    _lineColorHSBIncrement 
          = config.getDoubleArray(LINE_COLOR_HSB_INCREMENT_KEY, new double[3]);
    _lineThicknessIncrement 
          = config.getDouble(LINE_THICKNESS_INCREMENT_KEY, 0);
  }
  
  /**
   * Creates a new <tt>ShapeAttributesHint</tt> where all attributes has been
   * incremented.
   */
  public AttributesHint getNextHint() {
    ShapeAttributesHint nextHint = null;
    try {
      nextHint = (ShapeAttributesHint) clone();
    } catch (CloneNotSupportedException e) {}
    nextHint._fillColorHSB 
        = incrementColor(_fillColorHSB, _fillColorHSBIncrement);
    nextHint._lineColorHSB 
        = incrementColor(_lineColorHSB, _lineColorHSBIncrement);
    nextHint._lineThickness 
        = Math.max(0, _lineThickness + _lineThicknessIncrement);
    return nextHint;
  }

  /** Returns the wrapped {@link ShapeAttributes} instance. */
  public GraphicAttributes getAttributes() {
    return new ShapeAttributes(createColor(_fillColorHSB),
                               createColor(_lineColorHSB), 
                               _lineThickness, _linePattern);
  }
}
