// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

import jcckit.graphic.GraphicalElement;
import jcckit.graphic.Renderer;
import jcckit.plot.Plot;
import jcckit.plot.PlotCanvas;
import jcckit.renderer.Graphics2DRenderer;
import jcckit.renderer.Transformation;
import jcckit.util.ConfigParameters;
import jcckit.util.Factory;

/**
 * Class which handles plotting into a <tt>Graphics</tt> context based on the
 * {link jcckit.renderer.GraphicsRenderer}. This class is not a subclass of
 * <tt>java.awt.Component</tt>. The actual AWT component presenting the plot
 * is an innerclass. Its instance wrapped by <tt>GraphicsPlotCanvas</tt> can
 * be obtained with {link #getGraphicsCanvas}.
 * <p>
 * The plot is painted by using double-buffering and pre-rendered view of the
 * coordinate system. That is, the coordinate system is drawn into an off-screen
 * image. It will be redrawn only if the size of the embedding AWT component is
 * changed.
 *
 * @author Franz-Josef Elmer
 */
public class GraphicsPlotCanvas extends PlotCanvas {
	// ::remove folder when __CORE__
	// ::remove folder when __HAXE__
	// ::remove folder when __MIT__ or __EPL__ or __BSD__ or __ASL__ or __LGPL__
	/** Key of a configuration parameter. */
	public static final String BACKGROUND_KEY = "background";
	public static final String FOREGROUND_KEY = "foreground";
	public static final String DOUBLE_BUFFERING_KEY = "doubleBuffering";

	/**
	 * Class which does the actual painting. Needs the <tt>Component</tt> into
	 * which the plot is painted for some resources like size, background color,
	 * etc.
	 *
	 * @author Franz-Josef Elmer
	 */
	private final BufferedImage img3;

	private final Graphics2D g3;

	private Transformation _transformation;
	private String _renderer = "jcckit.renderer.GraphicsRenderer";

	private GraphicalElement _marker;

	/**
	 * Creates an instance from the specified configuration parameters. <table
	 * border=1 cellpadding=5>
	 * <tr>
	 * <th>Key &amp; Default Value</th>
	 * <th>Type</th>
	 * <th>Mandatory</th>
	 * <th>Description</th>
	 * </tr>
	 * <tr>
	 * <td><tt>background = </tt><i>default background color of the wrapped
	 * AWT component</i></td>
	 * <td><tt>Color</tt></td>
	 * <td>no</td>
	 * <td>Background color of the wrapped AWT component.</td>
	 * </tr>
	 * <tr>
	 * <td><tt>foreground = </tt><i>default foreground color of the wrapped
	 * AWT component</i></td>
	 * <td><tt>Color</tt></td>
	 * <td>no</td>
	 * <td>Foreground color of the wrapped AWT component.</td>
	 * </tr>
	 * <tr>
	 * <td><tt>doubleBuffering = true</tt></td>
	 *     <td><tt>boolean</tt></td><td>no</td>
	 *     <td>If <tt>true</tt> the plot will be painted by using
	 *         double-buffering and pre-rendered view of the coordinate system.
	 *     </td></tr>
	 * </table>
	 * In addition the configuration parameters of the
	 * <a href="plot/PlotCanvas.html#PlotCanvas(jcckit.util.ConfigParameters)">
	 * constructor</a> of the superclass {@link jcckit.plot.PlotCanvas} apply.
	 */
	public GraphicsPlotCanvas(ConfigParameters config, BufferedImage img3) {
		super(config);
		this.img3 = img3;
		setRenderer("jcckit.renderer.Graphics2DRenderer");

		g3 = img3.createGraphics();
		g3.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

		// _doubleBuffering = config.getBoolean(DOUBLE_BUFFERING_KEY, true);
		background = config.getColor(BACKGROUND_KEY, Color.WHITE);
		foreground = config.getColor(FOREGROUND_KEY, Color.BLACK);
	}

	private final Color background;
	private final Color foreground;

	/**
	 * Paints the plot. If {link GraphicsPlotCanvas#_doubleBuffering} is set
	 * double-buffering and pre-rendered view of the coordinate system is used.
	 */
	public void paint() {
		Dimension size = new Dimension(img3.getWidth(), img3.getHeight());
		g3.setColor(background);
		g3.fillRect(0, 0, size.width + 1, size.height + 1);

		init(size);

		_transformation.apply(g3);
		Plot plot = getPlot();
		drawCoordinateSystem(size, plot);
		drawPlot(plot);
		if (_marker != null) {
			_marker.renderWith(createRenderer());
		}
	}

	private void drawPlot(Plot plot) {
		prepare();
		Renderer renderer = createRenderer();
		GraphicalElement[] curves = plot.getCurves();
		for (int i = 0; i < curves.length; i++) {
			curves[i].renderWith(renderer);
		}
		GraphicalElement annotation = plot.getAnnotation();
		if (annotation != null) {
			annotation.renderWith(renderer);
		}
		if (plot.isLegendVisible()) {
			plot.getLegend().renderWith(renderer);
		}
	}

	private void init(Dimension size) {
		calculateTransformation(size);
	}

	private void drawCoordinateSystem(Dimension size, Plot plot) {
		g3.setColor(foreground);
		plot.getCoordinateSystem().renderWith(createRenderer());
	}

	/**
	 * Prepare graphics context before drawing the pre-rendered view of the
	 * coordinate system. Does nothing but will be used in subclasses.
	 */
	protected void prepare() {
	}

	/**
	 * Calculate the transformation form device-independent coordinates into
	 * device-dependent coordinates according to the specified canvas size.
	 */
	protected void calculateTransformation(Dimension size) {
		_transformation = new Transformation(size.width, size.height, getPaper(), getHorizontalAnchor(),
				getVerticalAnchor());
	}

	/**
	 * Creates an appropriated {@link Renderer} for the specified
	 * <tt>Graphics</tt> context.
	 */
	protected Renderer createRenderer() {
		return ((Graphics2DRenderer) Factory.create(_renderer)).init(g3);
		// return ((GraphicsRenderer) Factory.create(_renderer)).init(g, null,
		// _transformation);
	}

	/**
	 * Sets the renderer used to render the plot. The default value is
	 * {link GraphicsRenderer}.
	 *
	 * @param className
	 *            Fully qualified name of the renderer class.
	 */
	public void setRenderer(String className) {
		_renderer = className;
	}

	// /**
	// * Maps the cursor position onto a point in device-independent
	// coordinates.
	// *
	// * @param x
	// * X-coordinate of the cursor.
	// * @param y
	// * Y-coordinate of the cursor.
	// */
	// public GraphPoint mapCursorPosition(int x, int y) {
	// return _transformation.transformBack(x, y);
	// }

	/**
	 * Defines a graphical marker which will be drawn on top of the plot. To
	 * remove the marker call this method with argument <tt>null</tt>.
	 *
	 * @param marker
	 *            Marker element. Can be <tt>null</tt>.
	 */
	public void setMarker(GraphicalElement marker) {
		_marker = marker;
	}

}
