/*
 * Decompiled with CFR 0.152.
 */
package org.coode.suggestor.impl;

import java.util.HashSet;
import java.util.Set;
import org.coode.suggestor.api.PropertySanctionRule;
import org.coode.suggestor.api.PropertySuggestor;
import org.coode.suggestor.util.ReasonerHelper;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;

class PropertySuggestorImpl
implements PropertySuggestor {
    protected final OWLReasoner r;
    protected final OWLDataFactory df;
    protected final ReasonerHelper helper;
    private final Set<PropertySanctionRule> sanctionRules = new HashSet<PropertySanctionRule>();
    private final Matcher<OWLObjectPropertyExpression> currentOPMatcher = new AbstractOPMatcher(){

        @Override
        public boolean isMatch(OWLClassExpression c, OWLObjectPropertyExpression p) {
            if (p.isTopEntity()) {
                return true;
            }
            return PropertySuggestorImpl.this.helper.isDescendantOf(c, (OWLClassExpression)PropertySuggestorImpl.this.df.getOWLObjectSomeValuesFrom(p, (OWLClassExpression)PropertySuggestorImpl.this.df.getOWLThing()));
        }
    };
    private final Matcher<OWLDataProperty> currentDPMatcher = new AbstractDPMatcher(){

        @Override
        public boolean isMatch(OWLClassExpression c, OWLDataProperty p) {
            if (p.isTopEntity()) {
                return true;
            }
            return PropertySuggestorImpl.this.helper.isDescendantOf(c, (OWLClassExpression)PropertySuggestorImpl.this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)p, (OWLDataRange)PropertySuggestorImpl.this.df.getTopDatatype()));
        }
    };
    private Matcher<OWLObjectPropertyExpression> possibleOPMatcher = new AbstractOPMatcher(){

        @Override
        public boolean isMatch(OWLClassExpression c, OWLObjectPropertyExpression p) {
            return !PropertySuggestorImpl.this.r.isEntailed((OWLAxiom)PropertySuggestorImpl.this.df.getOWLSubClassOfAxiom(c, (OWLClassExpression)PropertySuggestorImpl.this.df.getOWLObjectAllValuesFrom(p, (OWLClassExpression)PropertySuggestorImpl.this.df.getOWLNothing())));
        }
    };
    private Matcher<OWLDataProperty> possibleDPMatcher = new AbstractDPMatcher(){

        @Override
        public boolean isMatch(OWLClassExpression c, OWLDataProperty p) {
            return PropertySuggestorImpl.this.r.isSatisfiable((OWLClassExpression)PropertySuggestorImpl.this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{c, PropertySuggestorImpl.this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)p, (OWLDataRange)PropertySuggestorImpl.this.df.getTopDatatype())}));
        }
    };

    public PropertySuggestorImpl(OWLReasoner r) {
        this.r = r;
        this.df = r.getRootOntology().getOWLOntologyManager().getOWLDataFactory();
        this.helper = new ReasonerHelper(r);
    }

    @Override
    public void addSanctionRule(PropertySanctionRule rule) {
        this.sanctionRules.add(rule);
        rule.setSuggestor(this);
    }

    @Override
    public void removeSanctionRule(PropertySanctionRule rule) {
        this.sanctionRules.remove(rule);
        rule.setSuggestor(null);
    }

    @Override
    public OWLReasoner getReasoner() {
        return this.r;
    }

    @Override
    public boolean isCurrent(OWLClassExpression c, OWLObjectPropertyExpression p) {
        return this.currentOPMatcher.isMatch(c, p);
    }

    @Override
    public boolean isCurrent(OWLClassExpression c, OWLObjectPropertyExpression p, boolean direct) {
        return this.currentOPMatcher.isMatch(c, p, direct);
    }

    @Override
    public boolean isCurrent(OWLClassExpression c, OWLDataProperty p) {
        return this.currentDPMatcher.isMatch(c, p);
    }

    @Override
    public boolean isCurrent(OWLClassExpression c, OWLDataProperty p, boolean direct) {
        return this.currentDPMatcher.isMatch(c, p, direct);
    }

    @Override
    public boolean isPossible(OWLClassExpression c, OWLObjectPropertyExpression p) {
        return this.possibleOPMatcher.isMatch(c, p);
    }

    @Override
    public boolean isPossible(OWLClassExpression c, OWLDataProperty p) {
        return this.possibleDPMatcher.isMatch(c, p);
    }

    @Override
    public boolean isSanctioned(OWLClassExpression c, OWLObjectPropertyExpression p) {
        return this.isPossible(c, p) && this.meetsOPSanctions(c, p);
    }

    @Override
    public boolean isSanctioned(OWLClassExpression c, OWLDataProperty p) {
        return this.isPossible(c, p) && this.meetsDPSanctions(c, p);
    }

    @Override
    public NodeSet<OWLObjectPropertyExpression> getCurrentObjectProperties(OWLClassExpression c, boolean direct) {
        return this.currentOPMatcher.getLeaves(c, (Node<OWLObjectPropertyExpression>)this.r.getTopObjectPropertyNode(), direct);
    }

    @Override
    public NodeSet<OWLDataProperty> getCurrentDataProperties(OWLClassExpression c, boolean direct) {
        return this.currentDPMatcher.getLeaves(c, (Node<OWLDataProperty>)this.r.getTopDataPropertyNode(), direct);
    }

    @Override
    public NodeSet<OWLObjectPropertyExpression> getPossibleObjectProperties(OWLClassExpression c, OWLObjectPropertyExpression root, boolean direct) {
        Node rootNode = root == null ? this.r.getTopObjectPropertyNode() : this.r.getEquivalentObjectProperties(root);
        return this.possibleOPMatcher.getRoots(c, (Node<OWLObjectPropertyExpression>)rootNode, direct);
    }

    @Override
    public NodeSet<OWLDataProperty> getPossibleDataProperties(OWLClassExpression c, OWLDataProperty root, boolean direct) {
        Node rootNode = root == null ? this.r.getTopDataPropertyNode() : this.r.getEquivalentDataProperties(root);
        return this.possibleDPMatcher.getRoots(c, (Node<OWLDataProperty>)rootNode, direct);
    }

    @Override
    public Set<OWLObjectPropertyExpression> getSanctionedObjectProperties(OWLClassExpression c, OWLObjectPropertyExpression root, boolean direct) {
        HashSet<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
        for (OWLObjectPropertyExpression pNode : this.getPossibleObjectProperties(c, root, direct).getFlattened()) {
            if (!this.meetsOPSanctions(c, pNode)) continue;
            props.add(pNode);
        }
        return props;
    }

    @Override
    public Set<OWLDataProperty> getSanctionedDataProperties(OWLClassExpression c, OWLDataProperty root, boolean direct) {
        HashSet<OWLDataProperty> props = new HashSet<OWLDataProperty>();
        for (OWLDataProperty pNode : this.getPossibleDataProperties(c, root, direct).getFlattened()) {
            if (!this.meetsDPSanctions(c, pNode)) continue;
            props.add(pNode);
        }
        return props;
    }

    private boolean meetsOPSanctions(OWLClassExpression c, OWLObjectPropertyExpression p) {
        for (PropertySanctionRule rule : this.sanctionRules) {
            if (!rule.meetsSanction(c, p)) continue;
            return true;
        }
        return false;
    }

    private boolean meetsDPSanctions(OWLClassExpression c, OWLDataProperty p) {
        for (PropertySanctionRule rule : this.sanctionRules) {
            if (!rule.meetsSanction(c, p)) continue;
            return true;
        }
        return false;
    }

    private abstract class AbstractDPMatcher
    extends AbstractMatcher<OWLDataProperty> {
        @Override
        protected final NodeSet<OWLDataProperty> getDirectSubs(OWLDataProperty p) {
            return PropertySuggestorImpl.this.r.getSubDataProperties(p, true);
        }

        @Override
        protected NodeSet<OWLDataProperty> createNodeSet(Set<Node<OWLDataProperty>> nodes) {
            return new OWLDataPropertyNodeSet(nodes);
        }
    }

    private abstract class AbstractOPMatcher
    extends AbstractMatcher<OWLObjectPropertyExpression> {
        @Override
        protected final NodeSet<OWLObjectPropertyExpression> getDirectSubs(OWLObjectPropertyExpression p) {
            return PropertySuggestorImpl.this.r.getSubObjectProperties(p, true);
        }

        @Override
        protected final NodeSet<OWLObjectPropertyExpression> createNodeSet(Set<Node<OWLObjectPropertyExpression>> nodes) {
            return new OWLObjectPropertyNodeSet(nodes);
        }
    }

    private abstract class AbstractMatcher<P extends OWLPropertyExpression<?, ?>>
    implements Matcher<P> {
        @Override
        public final boolean isMatch(OWLClassExpression c, P p, boolean direct) {
            if (!direct) {
                return this.isMatch(c, p);
            }
            if (!this.isMatch(c, p)) {
                return false;
            }
            for (Node node : this.getDirectSubs(p)) {
                if (!this.isMatch(c, (OWLPropertyExpression)node.getRepresentativeElement())) continue;
                return false;
            }
            return true;
        }

        @Override
        public final NodeSet<P> getLeaves(OWLClassExpression c, Node<P> root, boolean direct) {
            HashSet<Node<P>> nodes = new HashSet<Node<P>>();
            OWLPropertyExpression p = (OWLPropertyExpression)root.getRepresentativeElement();
            if (this.isMatch(c, p)) {
                for (Node sub : this.getDirectSubs(p)) {
                    nodes.addAll(this.getLeaves(c, sub, direct).getNodes());
                }
                if (!direct || nodes.isEmpty() && !root.isTopNode()) {
                    nodes.add(root);
                }
            }
            return this.createNodeSet(nodes);
        }

        @Override
        public final NodeSet<P> getRoots(OWLClassExpression c, Node<P> root, boolean direct) {
            HashSet<Node<P>> nodes = new HashSet<Node<P>>();
            for (Node sub : this.getDirectSubs((OWLPropertyExpression)root.getRepresentativeElement())) {
                if (!this.isMatch(c, (OWLPropertyExpression)sub.getRepresentativeElement())) continue;
                nodes.add(sub);
                if (direct) continue;
                nodes.addAll(this.getRoots(c, sub, direct).getNodes());
            }
            return this.createNodeSet(nodes);
        }

        protected abstract NodeSet<P> getDirectSubs(P var1);

        protected abstract NodeSet<P> createNodeSet(Set<Node<P>> var1);
    }

    private static interface Matcher<P extends OWLPropertyExpression<?, ?>> {
        public boolean isMatch(OWLClassExpression var1, P var2);

        public boolean isMatch(OWLClassExpression var1, P var2, boolean var3);

        public NodeSet<P> getLeaves(OWLClassExpression var1, Node<P> var2, boolean var3);

        public NodeSet<P> getRoots(OWLClassExpression var1, Node<P> var2, boolean var3);
    }
}

