/*
 * Decompiled with CFR 0.152.
 */
package org.coode.suggestor.impl;

import java.net.URI;
import java.net.URISyntaxException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;

public class IRIMatcher
implements OWLAnnotationValueVisitorEx<Boolean> {
    private final IRI propertyIRI;

    public IRIMatcher(IRI propertyIRI) {
        this.propertyIRI = propertyIRI;
    }

    public Boolean visit(IRI iri) {
        return iri.equals((Object)this.propertyIRI);
    }

    public Boolean visit(OWLAnonymousIndividual owlAnonymousIndividual) {
        return Boolean.FALSE;
    }

    public Boolean visit(OWLLiteral owlLiteral) {
        try {
            IRI vIRI = IRI.create((URI)new URI(owlLiteral.getLiteral()));
            if (vIRI.equals((Object)this.propertyIRI)) {
                return Boolean.TRUE;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return Boolean.FALSE;
    }
}

