/*
 * Decompiled with CFR 0.152.
 */
package org.coode.suggestor.test;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

@Ignore
public class ReasonerTests {
    public static final String JFACT_FACTORY = "uk.ac.manchester.cs.jfact.JFactFactory";

    @Test
    public void testReasoner() throws Exception {
        OWLOntologyManager mngr = OWLManager.createOWLOntologyManager();
        OWLOntology ont = mngr.createOntology();
        OWLReasonerFactory fac = (OWLReasonerFactory)Class.forName(JFACT_FACTORY).newInstance();
        OWLReasoner r = fac.createNonBufferingReasoner(ont);
        OWLDataFactory df = mngr.getOWLDataFactory();
        OWLClass a = df.getOWLClass(IRI.create((String)"http://example.com/a"));
        OWLClass b = df.getOWLClass(IRI.create((String)"http://example.com/b"));
        OWLClass c = df.getOWLClass(IRI.create((String)"http://example.com/c"));
        OWLObjectProperty p = df.getOWLObjectProperty(IRI.create((String)"http://example.com/p"));
        mngr.applyChange((OWLOntologyChange)new AddAxiom(ont, (OWLAxiom)df.getOWLSubClassOfAxiom((OWLClassExpression)a, (OWLClassExpression)df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)p, (OWLClassExpression)b))));
        mngr.applyChange((OWLOntologyChange)new AddAxiom(ont, (OWLAxiom)df.getOWLSubClassOfAxiom((OWLClassExpression)c, (OWLClassExpression)df.getOWLThing())));
        NodeSet subs = r.getSubClasses((OWLClassExpression)df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)p, (OWLClassExpression)b), true);
        Assert.assertEquals((long)1L, (long)subs.getNodes().size());
        Assert.assertTrue((boolean)subs.containsEntity((OWLObject)a));
        subs = r.getSubClasses((OWLClassExpression)df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)p, (OWLClassExpression)df.getOWLThing()), true);
        Assert.assertEquals((long)1L, (long)subs.getNodes().size());
        Assert.assertTrue((boolean)subs.containsEntity((OWLObject)a));
        subs = r.getSubClasses((OWLClassExpression)df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)df.getOWLTopObjectProperty(), (OWLClassExpression)df.getOWLThing()), true);
        Assert.assertEquals((long)3L, (long)subs.getNodes().size());
        Assert.assertTrue((boolean)subs.containsEntity((OWLObject)a));
        Assert.assertTrue((boolean)subs.containsEntity((OWLObject)b));
        Assert.assertTrue((boolean)subs.containsEntity((OWLObject)c));
    }

    @Test
    public void testReasoner4() throws Exception {
        OWLOntologyManager mngr = OWLManager.createOWLOntologyManager();
        OWLOntology ont = mngr.createOntology();
        OWLReasonerFactory fac = (OWLReasonerFactory)Class.forName(JFACT_FACTORY).newInstance();
        OWLReasoner r = fac.createNonBufferingReasoner(ont);
        Assert.assertFalse((boolean)r.getTopDataPropertyNode().getEntities().isEmpty());
    }
}

