/*
 * Decompiled with CFR 0.152.
 */
package org.coode.suggestor.test;

import java.util.ArrayList;
import org.coode.suggestor.api.FillerSuggestor;
import org.coode.suggestor.impl.SuggestorFactory;
import org.coode.suggestor.test.AbstractSuggestorTest;
import org.junit.Assert;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.vocab.OWLFacet;

public class FillerSuggestorTests
extends AbstractSuggestorTest {
    private OWLClass ca;
    private OWLClass cb;
    private OWLClass cc;
    private OWLClass cd;
    private OWLClass ce;
    private OWLClass ca1;
    private OWLClass cb1;
    private OWLClass cc1;
    private OWLObjectProperty oa;
    private OWLObjectProperty ob;
    private OWLObjectProperty ob1;
    private OWLDataProperty da;

    private void createEntities() {
        this.ca = this.createClass("ca");
        this.ca1 = this.createClass("ca1");
        this.cb = this.createClass("cb");
        this.cb1 = this.createClass("cb1");
        this.cc = this.createClass("cc");
        this.cc1 = this.createClass("cc1");
        this.cd = this.createClass("cd");
        this.ce = this.createClass("ce");
        this.oa = this.createObjectProperty("oa");
        this.ob = this.createObjectProperty("ob");
        this.ob1 = this.createObjectProperty("ob1");
        this.da = this.createDataProperty("da");
    }

    private OWLOntology createModelA() throws Exception {
        OWLOntology ont = this.createOntology();
        this.createEntities();
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.cb1, (OWLClassExpression)this.cb)));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ca1, (OWLClassExpression)this.ca)));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)this.ob1, (OWLObjectPropertyExpression)this.ob)));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ca, (OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.cb))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ca, (OWLClassExpression)this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)this.da, (OWLDataRange)this.df.getIntegerOWLDatatype()))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLEquivalentClassesAxiom((OWLClassExpression)this.cd, (OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.cb))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.cd, (OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.ce))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ca, (OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.cb1))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ca, (OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.ob1, (OWLClassExpression)this.cb))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.cc1, (OWLClassExpression)this.cc)));
        this.mngr.applyChanges(changes);
        return ont;
    }

    public void testIsCurrentFiller() throws Exception {
        OWLOntology ont = this.createModelA();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        SuggestorFactory fac = new SuggestorFactory(r);
        FillerSuggestor fs = fac.getFillerSuggestor();
        OWLDataFactory f = fs.getReasoner().getRootOntology().getOWLOntologyManager().getOWLDataFactory();
        System.out.println("FillerSuggestorTests.testIsCurrentFiller()\n" + fs.getReasoner().getRootOntology().getAxioms().toString().replace(",", ",\n\t"));
        System.out.println("FillerSuggestorTests.testIsCurrentFiller() subclasses of thing \n" + fs.getReasoner().getSubClasses((OWLClassExpression)f.getOWLThing(), true));
        System.out.println("FillerSuggestorTests.testIsCurrentFiller() subclasses of thing \n" + fs.getReasoner().getSubClasses((OWLClassExpression)f.getOWLThing(), false));
        Assert.assertTrue((boolean)fs.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.cb1, true));
        Assert.assertFalse((boolean)fs.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.cb, true));
        Assert.assertFalse((boolean)fs.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{this.cb, this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.ob, (OWLClassExpression)this.cc)}), true));
        Assert.assertFalse((boolean)fs.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.cc, true));
        Assert.assertTrue((boolean)fs.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.ce, true));
        Assert.assertTrue((boolean)fs.isCurrent((OWLClassExpression)this.ca, this.da, (OWLDataRange)this.df.getIntegerOWLDatatype(), true));
        Assert.assertFalse((boolean)fs.isCurrent((OWLClassExpression)this.ca, this.da, (OWLDataRange)this.df.getOWLDatatypeRestriction(this.df.getIntegerOWLDatatype(), OWLFacet.MIN_INCLUSIVE, this.df.getOWLLiteral(2)), true));
        Assert.assertFalse((boolean)fs.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.df.getOWLThing(), true));
        Assert.assertTrue((boolean)fs.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.cb1));
        Assert.assertTrue((boolean)fs.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.cb));
        Assert.assertFalse((boolean)fs.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{this.cb, this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.ob, (OWLClassExpression)this.cc)})));
        Assert.assertFalse((boolean)fs.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.cc));
        Assert.assertTrue((boolean)fs.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.df.getOWLThing()));
        Assert.assertTrue((boolean)fs.isCurrent((OWLClassExpression)this.ca, this.da, (OWLDataRange)this.df.getIntegerOWLDatatype()));
        Assert.assertTrue((boolean)fs.isCurrent((OWLClassExpression)this.ca, this.da, (OWLDataRange)this.df.getTopDatatype()));
        Assert.assertTrue((boolean)fs.isCurrent((OWLClassExpression)this.ca1, (OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.cb1, true));
    }

    private OWLOntology createModelB() throws Exception {
        OWLOntology ont = this.createOntology();
        this.createEntities();
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ca, (OWLClassExpression)this.df.getOWLObjectComplementOf((OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.cb)))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.cb1, (OWLClassExpression)this.cb)));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.cc1, (OWLClassExpression)this.cc)));
        this.mngr.applyChanges(changes);
        return ont;
    }

    public void testIsPossibleFiller() throws Exception {
        OWLOntology ont = this.createModelB();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        SuggestorFactory fac = new SuggestorFactory(r);
        FillerSuggestor fs = fac.getFillerSuggestor();
        Assert.assertTrue((boolean)fs.isPossible((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.ca));
        Assert.assertFalse((boolean)fs.isPossible((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.cb));
        Assert.assertTrue((boolean)fs.isPossible((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.cc));
        Assert.assertTrue((boolean)fs.isPossible((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.cc1));
        Assert.assertTrue((boolean)fs.isPossible((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.df.getOWLThing()));
    }

    public void testGetCurrentFillers() throws Exception {
        OWLOntology ont = this.createOntology();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        SuggestorFactory fac = new SuggestorFactory(r);
        FillerSuggestor fs = fac.getFillerSuggestor();
        this.createEntities();
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ca, (OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.oa, (OWLClassExpression)this.cb))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ca, (OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.ob, (OWLClassExpression)this.cc))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ca, (OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.ob, (OWLClassExpression)this.cd))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)this.ob, (OWLObjectPropertyExpression)this.oa)));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.cd, (OWLClassExpression)this.cc)));
        this.mngr.applyChanges(changes);
        NodeSet all = fs.getCurrentNamedFillers((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, false);
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.cb));
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.cc));
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.cd));
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.df.getOWLThing()));
        Assert.assertEquals((long)4L, (long)all.getNodes().size());
        NodeSet direct = fs.getCurrentNamedFillers((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, true);
        Assert.assertTrue((boolean)direct.containsEntity((OWLObject)this.cb));
        Assert.assertFalse((boolean)direct.containsEntity((OWLObject)this.cc));
        Assert.assertTrue((boolean)direct.containsEntity((OWLObject)this.cd));
        Assert.assertFalse((boolean)direct.containsEntity((OWLObject)this.df.getOWLThing()));
        Assert.assertEquals((long)2L, (long)direct.getNodes().size());
    }

    public void testGetPossibleFillers() throws Exception {
        OWLOntology ont = this.createModelA();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        SuggestorFactory fac = new SuggestorFactory(r);
        FillerSuggestor fs = fac.getFillerSuggestor();
        NodeSet pSuccessorsA = fs.getPossibleNamedFillers((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, null, false);
        Assert.assertEquals((long)8L, (long)pSuccessorsA.getNodes().size());
        Assert.assertTrue((boolean)pSuccessorsA.containsEntity((OWLObject)this.ca));
        Assert.assertTrue((boolean)pSuccessorsA.containsEntity((OWLObject)this.ca1));
        Assert.assertTrue((boolean)pSuccessorsA.containsEntity((OWLObject)this.cb));
        Assert.assertTrue((boolean)pSuccessorsA.containsEntity((OWLObject)this.cb1));
        Assert.assertTrue((boolean)pSuccessorsA.containsEntity((OWLObject)this.cc));
        Assert.assertTrue((boolean)pSuccessorsA.containsEntity((OWLObject)this.cc1));
        Assert.assertTrue((boolean)pSuccessorsA.containsEntity((OWLObject)this.cd));
        Assert.assertTrue((boolean)pSuccessorsA.containsEntity((OWLObject)this.ce));
        NodeSet pSuccessorsADirect = fs.getPossibleNamedFillers((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oa, null, true);
        Assert.assertEquals((long)4L, (long)pSuccessorsADirect.getNodes().size());
        Assert.assertTrue((boolean)pSuccessorsADirect.containsEntity((OWLObject)this.cb));
        Assert.assertTrue((boolean)pSuccessorsADirect.containsEntity((OWLObject)this.cc));
        Assert.assertTrue((boolean)pSuccessorsADirect.containsEntity((OWLObject)this.cd));
        Assert.assertTrue((boolean)pSuccessorsADirect.containsEntity((OWLObject)this.ce));
    }
}

