/*
 * Decompiled with CFR 0.152.
 */
package org.coode.suggestor.test;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.coode.suggestor.api.FillerSuggestor;
import org.coode.suggestor.api.PropertySuggestor;
import org.coode.suggestor.impl.SuggestorFactory;
import org.coode.suggestor.test.AbstractSuggestorTest;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class CreateExistentialTree
extends AbstractSuggestorTest {
    private final Set<Node<OWLClass>> visited = new HashSet<Node<OWLClass>>();

    @Override
    protected OWLOntology createOntology() throws OWLOntologyCreationException {
        return this.mngr.loadOntologyFromOntologyDocument(IRI.create((String)"http://www.co-ode.org/ontologies/pizza/pizza.owl"));
    }

    public void testCreateTree() throws Exception {
        OWLOntology ont = this.createOntology();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        SuggestorFactory fac = new SuggestorFactory(r);
        PropertySuggestor ps = fac.getPropertySuggestor();
        FillerSuggestor fs = fac.getFillerSuggestor();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 20; ++i) {
            this.visited.clear();
            this.printClass((Node<OWLClass>)r.getTopClassNode(), 0, ps, r, fs);
        }
        long end = System.currentTimeMillis();
        System.out.println("Complete in " + (end - start) + "ms");
    }

    private void printClass(Node<OWLClass> cNode, int indent, PropertySuggestor ps, OWLReasoner r, FillerSuggestor fs) {
        this.print(cNode, indent);
        if (this.visited.add(cNode)) {
            OWLClassExpression c = (OWLClassExpression)cNode.getRepresentativeElement();
            for (Node p : ps.getCurrentObjectProperties(c, true)) {
                this.printProperty(c, (Node<OWLObjectPropertyExpression>)p, indent + 3, fs);
            }
            for (Node sub : r.getSubClasses(c, true)) {
                if (sub.isBottomNode()) continue;
                this.printClass((Node<OWLClass>)sub, indent + 1, ps, r, fs);
            }
        }
    }

    private void printProperty(OWLClassExpression c, Node<OWLObjectPropertyExpression> p, int indent, FillerSuggestor fs) {
        this.print(p, indent);
        for (Node f : fs.getCurrentNamedFillers(c, (OWLObjectPropertyExpression)p.getRepresentativeElement(), true)) {
            this.print((Node<? extends OWLObject>)f, indent + 1);
        }
    }

    private void print(Node<? extends OWLObject> node, int indent) {
        System.out.println();
        for (int i = 0; i < indent; ++i) {
            System.out.print("    ");
        }
        boolean started = false;
        TreeSet entities = new TreeSet(node.getEntities());
        for (OWLObject o : entities) {
            if (started) {
                System.out.print(" == ");
            } else {
                started = true;
            }
            if (o instanceof OWLEntity) {
                System.out.print(((OWLEntity)o).getIRI().getFragment());
                continue;
            }
            System.out.print(o);
        }
    }
}

