/*
 * Decompiled with CFR 0.152.
 */
package org.coode.suggestor.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.impl.OWLDatatypeNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDatatypeNodeSet;

public class ReasonerHelper {
    private final OWLReasoner r;
    private final OWLDataFactory df;

    public ReasonerHelper(OWLReasoner r) {
        if (r == null) {
            throw new IllegalArgumentException("Reasoner cannot be null");
        }
        this.r = r;
        this.df = r.getRootOntology().getOWLOntologyManager().getOWLDataFactory();
    }

    public Set<OWLObjectPropertyExpression> getReferencedObjectProperties() {
        OWLOntology root = this.r.getRootOntology();
        HashSet<OWLObjectPropertyExpression> p = new HashSet<OWLObjectPropertyExpression>(root.getObjectPropertiesInSignature(true));
        p.add((OWLObjectPropertyExpression)this.df.getOWLTopObjectProperty());
        p.add((OWLObjectPropertyExpression)this.df.getOWLBottomObjectProperty());
        return p;
    }

    public Set<OWLDataProperty> getReferencedDataProperties() {
        OWLOntology root = this.r.getRootOntology();
        HashSet<OWLDataProperty> p = new HashSet<OWLDataProperty>(root.getDataPropertiesInSignature(true));
        p.add(this.df.getOWLTopDataProperty());
        p.add(this.df.getOWLBottomDataProperty());
        return p;
    }

    public boolean isDescendantOf(OWLClassExpression cls1, OWLClassExpression cls2) {
        if (!cls1.isAnonymous()) {
            return this.r.getSubClasses(cls2, false).containsEntity((OWLObject)cls1.asOWLClass());
        }
        return this.r.isEntailed((OWLAxiom)this.df.getOWLSubClassOfAxiom(cls1, cls2));
    }

    public boolean isAncestorOf(OWLClassExpression cls1, OWLClassExpression cls2) {
        if (!cls1.isAnonymous()) {
            return this.r.getSuperClasses(cls2, false).containsEntity((OWLObject)cls1.asOWLClass());
        }
        return this.r.isEntailed((OWLAxiom)this.df.getOWLSubClassOfAxiom(cls2, cls1));
    }

    public Set<OWLClassExpression> filterClassExpressions(Set<OWLClassExpression> clses) {
        HashSet<OWLClassExpression> nonRedundantSet = new HashSet<OWLClassExpression>();
        ArrayList<OWLClassExpression> clsList = new ArrayList<OWLClassExpression>(clses);
        for (int i = 0; i < clsList.size(); ++i) {
            OWLClassExpression head = (OWLClassExpression)clsList.get(i);
            if (this.containsSubclass(clsList.subList(i + 1, clsList.size()), head) || this.containsSubclass(nonRedundantSet, head)) continue;
            nonRedundantSet.add(head);
        }
        return nonRedundantSet;
    }

    public boolean containsSubclass(Collection<OWLClassExpression> potentialSubs, OWLClassExpression cls) {
        for (OWLClassExpression potentialSub : potentialSubs) {
            if (!this.isDescendantOf(potentialSub, cls)) continue;
            return true;
        }
        return false;
    }

    public boolean isLocallyFunctional(OWLClassExpression c, OWLObjectPropertyExpression p) {
        return this.isDescendantOf(c, (OWLClassExpression)this.df.getOWLObjectMaxCardinality(1, p));
    }

    public boolean isLocallyFunctional(OWLClassExpression c, OWLDataProperty p) {
        return this.isDescendantOf(c, (OWLClassExpression)this.df.getOWLDataMaxCardinality(1, (OWLDataPropertyExpression)p));
    }

    public OWLClassExpression getGlobalAssertedRange(OWLObjectPropertyExpression p) {
        Object range = this.df.getOWLThing();
        Set<OWLClassExpression> assertedRanges = new HashSet<OWLClassExpression>();
        HashSet<OWLObjectPropertyExpression> ancestors = new HashSet<OWLObjectPropertyExpression>(this.r.getSuperObjectProperties(p, false).getFlattened());
        ancestors.add(p);
        for (OWLOntology ont : this.r.getRootOntology().getImportsClosure()) {
            for (OWLObjectPropertyExpression ancestor : ancestors) {
                assertedRanges.addAll(ancestor.getRanges(ont));
            }
        }
        if (!assertedRanges.isEmpty()) {
            range = (assertedRanges = this.filterClassExpressions(assertedRanges)).size() == 1 ? assertedRanges.iterator().next() : this.df.getOWLObjectIntersectionOf(assertedRanges);
        }
        return range;
    }

    public OWLDataRange getGlobalAssertedRange(OWLDataProperty p) {
        Object range = this.df.getTopDatatype();
        HashSet assertedRanges = new HashSet();
        HashSet<OWLDataProperty> ancestors = new HashSet<OWLDataProperty>(this.r.getSuperDataProperties(p, false).getFlattened());
        ancestors.add(p);
        for (OWLOntology ont : this.r.getRootOntology().getImportsClosure()) {
            for (OWLDataProperty ancestor : ancestors) {
                assertedRanges.addAll(ancestor.getRanges(ont));
            }
        }
        if (!assertedRanges.isEmpty()) {
            range = assertedRanges.size() == 1 ? (OWLDataRange)assertedRanges.iterator().next() : this.df.getOWLDataIntersectionOf(assertedRanges);
        }
        return range;
    }

    public boolean isSubtype(OWLDataRange subRange, OWLDataRange superRange) {
        OWLDataPropertyExpression p = this.getCandidatePropForRangeSubsumptionCheck(superRange);
        if (p == null) {
            throw new RuntimeException("Cannot find a candidate property for datatype subsumption checking");
        }
        return this.r.isEntailed((OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.df.getOWLDataSomeValuesFrom(p, subRange), (OWLClassExpression)this.df.getOWLDataSomeValuesFrom(p, superRange)));
    }

    public NodeSet<OWLDatatype> getSubtypes(OWLDataRange range) {
        OWLDataPropertyExpression p = this.getCandidatePropForRangeSubsumptionCheck(range);
        if (p == null) {
            throw new RuntimeException("Cannot find a candidate property for datatype subsumption checking");
        }
        HashSet<OWLDatatypeNode> subs = new HashSet<OWLDatatypeNode>();
        OWLDataSomeValuesFrom pSomeRange = this.df.getOWLDataSomeValuesFrom(p, range);
        for (OWLDatatype dt : this.getDatatypesInSignature()) {
            if (dt.equals(range)) continue;
            OWLDataSomeValuesFrom pSomeDatatype = this.df.getOWLDataSomeValuesFrom(p, (OWLDataRange)dt);
            if (!this.r.isSatisfiable((OWLClassExpression)pSomeDatatype)) {
                System.err.println("Warning: unsatisfiable concept in subtype checking: " + pSomeDatatype);
                continue;
            }
            if (!this.r.isEntailed((OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)pSomeDatatype, (OWLClassExpression)pSomeRange))) continue;
            subs.add(new OWLDatatypeNode(dt));
        }
        return new OWLDatatypeNodeSet(subs);
    }

    public Node<OWLDatatype> getEquivalentTypes(OWLDataRange range) {
        OWLDataPropertyExpression p = this.getCandidatePropForRangeSubsumptionCheck(range);
        if (p == null) {
            throw new RuntimeException("Cannot find a candidate property for datatype subsumption checking");
        }
        HashSet<OWLDatatype> subs = new HashSet<OWLDatatype>();
        if (range.isDatatype()) {
            subs.add(range.asOWLDatatype());
        }
        OWLDataSomeValuesFrom pSomeRange = this.df.getOWLDataSomeValuesFrom(p, range);
        for (OWLDatatype dt : this.getDatatypesInSignature()) {
            if (dt.equals(range)) continue;
            OWLDataSomeValuesFrom pSomeDatatype = this.df.getOWLDataSomeValuesFrom(p, (OWLDataRange)dt);
            if (!this.r.isSatisfiable((OWLClassExpression)pSomeDatatype)) {
                System.err.println("Warning: unsatisfiable concept in equiv type checking: " + pSomeDatatype);
                continue;
            }
            if (!this.r.isEntailed((OWLAxiom)this.df.getOWLEquivalentClassesAxiom((OWLClassExpression)pSomeDatatype, (OWLClassExpression)pSomeRange))) continue;
            subs.add(dt);
        }
        return new OWLDatatypeNode(subs);
    }

    public OWLDataPropertyExpression getCandidatePropForRangeSubsumptionCheck(OWLDataRange range) {
        for (OWLOntology ont : this.r.getRootOntology().getImportsClosure()) {
            for (OWLDataProperty p : ont.getDataPropertiesInSignature()) {
                if (p.isTopEntity() || !this.r.isSatisfiable((OWLClassExpression)this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)p, range))) continue;
                return p;
            }
        }
        return null;
    }

    public Set<OWLDatatype> getDatatypesInSignature() {
        HashSet<OWLDatatype> dts = new HashSet<OWLDatatype>();
        for (OWLOntology ont : this.r.getRootOntology().getImportsClosure()) {
            dts.addAll(ont.getDatatypesInSignature());
        }
        return dts;
    }

    public boolean isInAssertedRange(OWLObjectPropertyExpression p, OWLClassExpression f) {
        return this.isDescendantOf(f, this.getGlobalAssertedRange(p));
    }

    public boolean isInAssertedRange(OWLDataProperty p, OWLDataRange f) {
        return this.isSubtype(f, this.getGlobalAssertedRange(p));
    }
}

