/*
 * Decompiled with CFR 0.152.
 */
package org.coode.suggestor.util;

import org.coode.suggestor.util.FillerAccumulator;
import org.coode.suggestor.util.RestrictionVisitor;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLRestriction;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class NamedEntityFillerAccumulator
extends FillerAccumulator<OWLEntity> {
    public NamedEntityFillerAccumulator(OWLReasoner r) {
        super(r);
    }

    @Override
    protected RestrictionVisitor getVisitor(OWLPropertyExpression<?, ?> prop, Class<? extends OWLRestriction<?, ?, ?>> type) {
        return new RestrictionVisitor(this.r, prop, type){

            @Override
            public void visit(OWLObjectSomeValuesFrom desc) {
                OWLClassExpression filler;
                super.visit(desc);
                if (this.props.contains(desc.getProperty()) && !(filler = (OWLClassExpression)desc.getFiller()).isAnonymous()) {
                    NamedEntityFillerAccumulator.this.add(filler.asOWLClass());
                }
            }

            @Override
            public void visit(OWLObjectMinCardinality desc) {
                OWLClassExpression filler;
                super.visit(desc);
                if (desc.getCardinality() > 0 && this.props.contains(desc.getProperty()) && (filler = (OWLClassExpression)desc.getFiller()) != null && !filler.isAnonymous()) {
                    NamedEntityFillerAccumulator.this.add(filler.asOWLClass());
                }
            }

            @Override
            public void visit(OWLObjectExactCardinality desc) {
                OWLClassExpression filler;
                super.visit(desc);
                if (desc.getCardinality() > 0 && this.props.contains(desc.getProperty()) && (filler = (OWLClassExpression)desc.getFiller()) != null && !filler.isAnonymous()) {
                    NamedEntityFillerAccumulator.this.add(filler.asOWLClass());
                }
            }

            @Override
            public void visit(OWLObjectHasValue desc) {
                OWLIndividual ind;
                super.visit(desc);
                if (this.props.contains(desc.getProperty()) && !(ind = (OWLIndividual)desc.getValue()).isAnonymous()) {
                    NamedEntityFillerAccumulator.this.add(ind.asOWLNamedIndividual());
                }
            }
        };
    }
}

