/*
 * Decompiled with CFR 0.152.
 */
package org.coode.suggestor.impl;

import java.util.HashSet;
import java.util.Set;
import org.coode.suggestor.api.FillerSanctionRule;
import org.coode.suggestor.api.FillerSuggestor;
import org.coode.suggestor.util.ReasonerHelper;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDatatypeNodeSet;

class FillerSuggestorImpl
implements FillerSuggestor {
    protected final OWLReasoner r;
    protected final OWLDataFactory df;
    protected final ReasonerHelper helper;
    private final Set<FillerSanctionRule> sanctioningRules = new HashSet<FillerSanctionRule>();
    private final AbstractOPMatcher currentOPMatcher = new AbstractOPMatcher(){

        @Override
        public boolean isMatch(OWLClassExpression c, OWLObjectPropertyExpression p, OWLClassExpression f) {
            return FillerSuggestorImpl.this.helper.isDescendantOf(c, (OWLClassExpression)FillerSuggestorImpl.this.df.getOWLObjectSomeValuesFrom(p, f));
        }
    };
    private final AbstractDPMatcher currentDPMatcher = new AbstractDPMatcher(){

        @Override
        public boolean isMatch(OWLClassExpression c, OWLDataPropertyExpression p, OWLDataRange f) {
            return FillerSuggestorImpl.this.helper.isDescendantOf(c, (OWLClassExpression)FillerSuggestorImpl.this.df.getOWLDataSomeValuesFrom(p, f));
        }
    };
    private final AbstractOPMatcher possibleOPMatcher = new AbstractOPMatcher(){

        @Override
        public boolean isMatch(OWLClassExpression c, OWLObjectPropertyExpression p, OWLClassExpression f) {
            return !FillerSuggestorImpl.this.r.isSatisfiable((OWLClassExpression)FillerSuggestorImpl.this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{c, FillerSuggestorImpl.this.df.getOWLObjectAllValuesFrom(p, (OWLClassExpression)FillerSuggestorImpl.this.df.getOWLObjectComplementOf(f))}));
        }
    };
    private final AbstractDPMatcher possibleDPMatcher = new AbstractDPMatcher(){

        @Override
        public boolean isMatch(OWLClassExpression c, OWLDataPropertyExpression p, OWLDataRange f) {
            return !FillerSuggestorImpl.this.r.isSatisfiable((OWLClassExpression)FillerSuggestorImpl.this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{c, FillerSuggestorImpl.this.df.getOWLDataAllValuesFrom(p, (OWLDataRange)FillerSuggestorImpl.this.df.getOWLDataComplementOf(f))}));
        }
    };

    public FillerSuggestorImpl(OWLReasoner r) {
        this.r = r;
        this.df = r.getRootOntology().getOWLOntologyManager().getOWLDataFactory();
        this.helper = new ReasonerHelper(r);
    }

    @Override
    public void addSanctionRule(FillerSanctionRule rule) {
        this.sanctioningRules.add(rule);
        rule.setSuggestor(this);
    }

    @Override
    public void removeSanctionRule(FillerSanctionRule rule) {
        this.sanctioningRules.remove(rule);
        rule.setSuggestor(null);
    }

    @Override
    public OWLReasoner getReasoner() {
        return this.r;
    }

    @Override
    public boolean isCurrent(OWLClassExpression c, OWLObjectPropertyExpression p, OWLClassExpression f) {
        return this.currentOPMatcher.isMatch(c, p, f);
    }

    @Override
    public boolean isCurrent(OWLClassExpression c, OWLObjectPropertyExpression p, OWLClassExpression f, boolean direct) {
        return this.currentOPMatcher.isMatch(c, p, f, direct);
    }

    @Override
    public boolean isCurrent(OWLClassExpression c, OWLDataProperty p, OWLDataRange f) {
        return this.currentDPMatcher.isMatch(c, p, f);
    }

    @Override
    public boolean isCurrent(OWLClassExpression c, OWLDataProperty p, OWLDataRange f, boolean direct) {
        return this.currentDPMatcher.isMatch(c, p, f, direct);
    }

    @Override
    public boolean isPossible(OWLClassExpression c, OWLObjectPropertyExpression p, OWLClassExpression f) {
        return this.possibleOPMatcher.isMatch(c, p, f);
    }

    @Override
    public boolean isPossible(OWLClassExpression c, OWLDataProperty p, OWLDataRange f) {
        return this.possibleDPMatcher.isMatch(c, p, f);
    }

    @Override
    public boolean isSanctioned(OWLClassExpression c, OWLObjectPropertyExpression p, OWLClassExpression f) {
        return this.isPossible(c, p, f) && this.meetsSanctions(c, p, f);
    }

    @Override
    public boolean isSanctioned(OWLClassExpression c, OWLDataProperty p, OWLDataRange f) {
        return this.isPossible(c, p, f) && this.meetsSanctions(c, p, f);
    }

    @Override
    public boolean isRedundant(OWLClassExpression c, OWLObjectPropertyExpression p, OWLClassExpression f) {
        if (this.isCurrent(c, p, f)) {
            return true;
        }
        for (Node node : this.r.getSubClasses(f, true)) {
            OWLClass sub = (OWLClass)node.getRepresentativeElement();
            if (!this.isCurrent(c, p, (OWLClassExpression)sub) && !this.helper.isDescendantOf(c, (OWLClassExpression)this.df.getOWLObjectAllValuesFrom(p, (OWLClassExpression)sub))) continue;
            return true;
        }
        return false;
    }

    @Override
    public NodeSet<OWLClass> getCurrentNamedFillers(OWLClassExpression c, OWLObjectPropertyExpression p, boolean direct) {
        return this.currentOPMatcher.getLeaves(c, p, this.helper.getGlobalAssertedRange(p), direct);
    }

    @Override
    public NodeSet<OWLClass> getPossibleNamedFillers(OWLClassExpression c, OWLObjectPropertyExpression p, OWLClassExpression root, boolean direct) {
        return this.possibleOPMatcher.getRoots(c, p, root == null ? this.helper.getGlobalAssertedRange(p) : root, direct);
    }

    @Override
    public Set<OWLClass> getSanctionedFillers(OWLClassExpression c, OWLObjectPropertyExpression p, OWLClassExpression root, boolean direct) {
        HashSet<OWLClass> fillers = new HashSet<OWLClass>();
        for (OWLClass f : this.getPossibleNamedFillers(c, p, root, direct).getFlattened()) {
            if (!this.meetsSanctions(c, p, (OWLClassExpression)f)) continue;
            fillers.add(f);
        }
        return fillers;
    }

    private boolean meetsSanctions(OWLClassExpression c, OWLObjectPropertyExpression p, OWLClassExpression f) {
        for (FillerSanctionRule rule : this.sanctioningRules) {
            if (!rule.meetsSanction(c, p, f)) continue;
            return true;
        }
        return false;
    }

    private boolean meetsSanctions(OWLClassExpression c, OWLDataProperty p, OWLDataRange f) {
        for (FillerSanctionRule rule : this.sanctioningRules) {
            if (!rule.meetsSanction(c, p, f)) continue;
            return true;
        }
        return false;
    }

    private abstract class AbstractDPMatcher
    extends AbstractMatcher<OWLDataRange, OWLDatatype, OWLDataPropertyExpression> {
        @Override
        protected final NodeSet<OWLDatatype> getDirectSubs(OWLDataRange range) {
            return FillerSuggestorImpl.this.helper.getSubtypes(range);
        }

        @Override
        protected Node<OWLDatatype> getEquivalents(OWLDataRange range) {
            return FillerSuggestorImpl.this.helper.getEquivalentTypes(range);
        }

        @Override
        protected NodeSet<OWLDatatype> createNodeSet(Set<Node<OWLDatatype>> nodes) {
            return new OWLDatatypeNodeSet(nodes);
        }
    }

    private abstract class AbstractOPMatcher
    extends AbstractMatcher<OWLClassExpression, OWLClass, OWLObjectPropertyExpression> {
        @Override
        protected final NodeSet<OWLClass> getDirectSubs(OWLClassExpression c) {
            return FillerSuggestorImpl.this.r.getSubClasses(c, true);
        }

        @Override
        protected Node<OWLClass> getEquivalents(OWLClassExpression f) {
            return FillerSuggestorImpl.this.r.getEquivalentClasses(f);
        }

        @Override
        protected final NodeSet<OWLClass> createNodeSet(Set<Node<OWLClass>> nodes) {
            return new OWLClassNodeSet(nodes);
        }
    }

    private abstract class AbstractMatcher<R extends OWLPropertyRange, F extends R, P extends OWLPropertyExpression<R, P>>
    implements Matcher<R, F, P> {
        @Override
        public final boolean isMatch(OWLClassExpression c, P p, R f, boolean direct) {
            if (!direct) {
                return this.isMatch(c, p, f);
            }
            if (!this.isMatch(c, p, f)) {
                return false;
            }
            NodeSet<F> directSubs = this.getDirectSubs(f);
            for (Node node : directSubs) {
                OWLPropertyRange representativeElement = (OWLPropertyRange)node.getRepresentativeElement();
                if (representativeElement == null) {
                    System.out.println("FillerSuggestorImpl.AbstractMatcher.isMatch() " + f);
                }
                if (!this.isMatch(c, p, representativeElement)) continue;
                return false;
            }
            return true;
        }

        @Override
        public final NodeSet<F> getLeaves(OWLClassExpression c, P p, R start, boolean direct) {
            HashSet<Node<F>> nodes = new HashSet<Node<F>>();
            if (this.isMatch(c, p, start)) {
                for (Node sub : this.getDirectSubs(start)) {
                    nodes.addAll(this.getLeaves(c, p, (OWLPropertyRange)sub.getRepresentativeElement(), direct).getNodes());
                }
                if (!direct || nodes.isEmpty() && !start.isTopEntity()) {
                    nodes.add(this.getEquivalents(start));
                }
            }
            return this.createNodeSet(nodes);
        }

        @Override
        public final NodeSet<F> getRoots(OWLClassExpression c, P p, R start, boolean direct) {
            HashSet<Node<F>> nodes = new HashSet<Node<F>>();
            for (Node sub : this.getDirectSubs(start)) {
                if (!this.isMatch(c, p, (OWLPropertyRange)sub.getRepresentativeElement())) continue;
                nodes.add(sub);
                if (direct) continue;
                nodes.addAll(this.getRoots(c, p, (OWLPropertyRange)sub.getRepresentativeElement(), direct).getNodes());
            }
            return this.createNodeSet(nodes);
        }

        protected abstract NodeSet<F> getDirectSubs(R var1);

        protected abstract Node<F> getEquivalents(R var1);

        protected abstract NodeSet<F> createNodeSet(Set<Node<F>> var1);
    }

    private static interface Matcher<R extends OWLPropertyRange, F extends R, P extends OWLPropertyExpression<R, P>> {
        public boolean isMatch(OWLClassExpression var1, P var2, R var3);

        public boolean isMatch(OWLClassExpression var1, P var2, R var3, boolean var4);

        public NodeSet<F> getLeaves(OWLClassExpression var1, P var2, R var3, boolean var4);

        public NodeSet<F> getRoots(OWLClassExpression var1, P var2, R var3, boolean var4);
    }
}

