/*
 * Decompiled with CFR 0.152.
 */
package org.coode.suggestor.test;

import java.util.Arrays;
import org.coode.suggestor.test.AbstractSuggestorTest;
import org.coode.suggestor.util.ReasonerHelper;
import org.junit.Assert;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.vocab.OWLFacet;

public class UtilTests
extends AbstractSuggestorTest {
    public void testGetSubDatatypes() throws Exception {
        OWLOntology ont = this.createOntology();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        ReasonerHelper helper = new ReasonerHelper(r);
        OWLDataProperty p = this.df.getOWLDataProperty(IRI.create((String)"http://example.com/p"));
        OWLDatatype integer = this.df.getIntegerOWLDatatype();
        OWLDatatype flt = this.df.getFloatOWLDatatype();
        OWLDatatype dbl = this.df.getDoubleOWLDatatype();
        this.mngr.applyChanges(Arrays.asList(new AddAxiom(ont, (OWLAxiom)this.df.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)p)), new AddAxiom(ont, (OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)integer)), new AddAxiom(ont, (OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)dbl)), new AddAxiom(ont, (OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)flt))));
        NodeSet subs = helper.getSubtypes((OWLDataRange)this.df.getTopDatatype());
        System.out.println(subs);
        Assert.assertEquals((long)3L, (long)subs.getNodes().size());
        Assert.assertTrue((boolean)subs.containsEntity((OWLObject)integer));
        Assert.assertTrue((boolean)subs.containsEntity((OWLObject)flt));
        Assert.assertTrue((boolean)subs.containsEntity((OWLObject)dbl));
        NodeSet subsOfFloat = helper.getSubtypes((OWLDataRange)dbl);
        System.out.println(subsOfFloat);
        Assert.assertEquals((long)0L, (long)subsOfFloat.getNodes().size());
        Assert.assertFalse((boolean)helper.isSubtype((OWLDataRange)flt, (OWLDataRange)integer));
        Assert.assertTrue((boolean)helper.isSubtype((OWLDataRange)this.df.getOWLDatatypeRestriction(integer, new OWLFacetRestriction[]{this.df.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, 2)}), (OWLDataRange)integer));
        Assert.assertFalse((boolean)helper.isSubtype((OWLDataRange)this.df.getOWLDatatypeRestriction(flt, new OWLFacetRestriction[]{this.df.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, 2.0f)}), (OWLDataRange)integer));
        Assert.assertTrue((boolean)helper.isSubtype((OWLDataRange)this.df.getOWLDatatypeRestriction(integer, new OWLFacetRestriction[]{this.df.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, 4)}), (OWLDataRange)this.df.getOWLDatatypeRestriction(integer, new OWLFacetRestriction[]{this.df.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, 2)})));
    }

    public void testAssertedRange() {
    }
}

