/*
 * Decompiled with CFR 0.152.
 */
package org.coode.suggestor.test;

import java.util.ArrayList;
import org.coode.suggestor.api.PropertySanctionRule;
import org.coode.suggestor.api.PropertySuggestor;
import org.coode.suggestor.impl.SimpleAnnotationPropertySanctionRule;
import org.coode.suggestor.impl.SuggestorFactory;
import org.coode.suggestor.test.AbstractSuggestorTest;
import org.junit.Assert;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class PropertySuggestorTests
extends AbstractSuggestorTest {
    OWLClass ca;
    OWLClass cb;
    OWLClass cc;
    OWLClass cd;
    OWLClass ce;
    OWLClass cf;
    OWLObjectProperty op;
    OWLObjectProperty oq;
    OWLObjectProperty or;
    OWLObjectProperty os;
    OWLObjectProperty ot;
    OWLDataProperty dx;
    OWLDataProperty dy;
    OWLDataProperty z;

    private void createEntities() {
        this.ca = this.createClass("a");
        this.cb = this.createClass("b");
        this.cc = this.createClass("c");
        this.cd = this.createClass("d");
        this.ce = this.createClass("e");
        this.cf = this.createClass("f");
        this.op = this.createObjectProperty("p");
        this.oq = this.createObjectProperty("q");
        this.or = this.createObjectProperty("r");
        this.os = this.createObjectProperty("s");
        this.ot = this.createObjectProperty("t");
        this.dx = this.createDataProperty("x");
        this.dy = this.createDataProperty("y");
    }

    private OWLOntology createModelA() throws Exception {
        OWLOntology ont = this.createOntology();
        this.createEntities();
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ca, (OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.cb))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ca, (OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.oq, (OWLClassExpression)this.cb))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ca, (OWLClassExpression)this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)this.dx, (OWLDataRange)this.df.getIntegerOWLDatatype()))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.cc, (OWLClassExpression)this.ca)));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.cc, (OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.ot, (OWLClassExpression)this.cb))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)this.oq, (OWLObjectPropertyExpression)this.or)));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ca, (OWLClassExpression)this.df.getOWLObjectComplementOf((OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.os, (OWLClassExpression)this.df.getOWLThing())))));
        this.mngr.applyChanges(changes);
        return ont;
    }

    private OWLOntology createModelB() throws Exception {
        OWLOntology ont = this.createOntology();
        this.createEntities();
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ca, (OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.cb))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ca, (OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.oq, (OWLClassExpression)this.cb))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ca, (OWLClassExpression)this.df.getOWLObjectComplementOf((OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.os, (OWLClassExpression)this.df.getOWLThing())))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)this.or, (OWLObjectPropertyExpression)this.os)));
        this.mngr.applyChanges(changes);
        return ont;
    }

    public void testIsCurrentObjectProperties() throws Exception {
        OWLOntology ont = this.createModelA();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        SuggestorFactory fac = new SuggestorFactory(r);
        PropertySuggestor ps = fac.getPropertySuggestor();
        OWLObjectProperty topOP = this.df.getOWLTopObjectProperty();
        OWLDataProperty topDP = this.df.getOWLTopDataProperty();
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.op));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oq));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.or));
        Assert.assertFalse((boolean)ps.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.os));
        Assert.assertFalse((boolean)ps.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.ot));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)topOP));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.ca, this.dx));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.ca, topDP));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.op, true));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oq, true));
        Assert.assertFalse((boolean)ps.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.or, true));
        Assert.assertFalse((boolean)ps.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.os, true));
        Assert.assertFalse((boolean)ps.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.ot, true));
        Assert.assertFalse((boolean)ps.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)topOP, true));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.ca, this.dx, true));
        Assert.assertFalse((boolean)ps.isCurrent((OWLClassExpression)this.ca, topDP, true));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)this.op));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)this.oq));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)this.or));
        Assert.assertFalse((boolean)ps.isCurrent((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)this.os));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)this.ot));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)topOP));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.cc, this.dx));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.cc, topDP));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)this.op, true));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)this.oq, true));
        Assert.assertFalse((boolean)ps.isCurrent((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)this.or, true));
        Assert.assertFalse((boolean)ps.isCurrent((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)this.os, true));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)this.ot, true));
        Assert.assertFalse((boolean)ps.isCurrent((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)topOP, true));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.cc, this.dx, true));
        Assert.assertFalse((boolean)ps.isCurrent((OWLClassExpression)this.cc, topDP, true));
    }

    public void testIsPossibleObjectProperties() throws Exception {
        OWLOntology ont = this.createModelA();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        SuggestorFactory fac = new SuggestorFactory(r);
        PropertySuggestor ps = fac.getPropertySuggestor();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)ps.isPossible((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.op));
            Assert.assertTrue((boolean)ps.isPossible((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oq));
            Assert.assertTrue((boolean)ps.isPossible((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.or));
            Assert.assertFalse((boolean)ps.isPossible((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.os));
            Assert.assertTrue((boolean)ps.isPossible((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.ot));
            Assert.assertTrue((boolean)ps.isPossible((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.df.getOWLTopObjectProperty()));
            Assert.assertTrue((boolean)ps.isPossible((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)this.op));
            Assert.assertTrue((boolean)ps.isPossible((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)this.oq));
            Assert.assertTrue((boolean)ps.isPossible((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)this.or));
            Assert.assertFalse((boolean)ps.isPossible((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)this.os));
            Assert.assertTrue((boolean)ps.isPossible((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)this.ot));
            Assert.assertTrue((boolean)ps.isPossible((OWLClassExpression)this.cc, (OWLObjectPropertyExpression)this.df.getOWLTopObjectProperty()));
        }
        long end = System.currentTimeMillis();
        System.out.println(end - start + "ms");
    }

    public void testIsImpossibleObjectProperties() throws Exception {
        OWLOntology ont = this.createModelB();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        SuggestorFactory fac = new SuggestorFactory(r);
        PropertySuggestor ps = fac.getPropertySuggestor();
        Assert.assertTrue((boolean)ps.isPossible((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.op));
        Assert.assertTrue((boolean)ps.isPossible((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oq));
        Assert.assertFalse((boolean)ps.isPossible((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.or));
        Assert.assertFalse((boolean)ps.isPossible((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.os));
        Assert.assertTrue((boolean)ps.isPossible((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.df.getOWLTopObjectProperty()));
    }

    public void testGetCurrentObjectProperties() throws Exception {
        OWLOntology ont = this.createModelA();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        SuggestorFactory fac = new SuggestorFactory(r);
        PropertySuggestor ps = fac.getPropertySuggestor();
        NodeSet direct = ps.getCurrentObjectProperties((OWLClassExpression)this.ca, true);
        Assert.assertTrue((boolean)direct.containsEntity((OWLObject)this.op));
        Assert.assertTrue((boolean)direct.containsEntity((OWLObject)this.oq));
        Assert.assertEquals((long)2L, (long)direct.getNodes().size());
        NodeSet all = ps.getCurrentObjectProperties((OWLClassExpression)this.ca, false);
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.op));
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.oq));
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.or));
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.df.getOWLTopObjectProperty()));
        Assert.assertEquals((long)4L, (long)all.getNodes().size());
    }

    public void testGetCurrentDataProperties() throws Exception {
        OWLOntology ont = this.createModelA();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        SuggestorFactory fac = new SuggestorFactory(r);
        PropertySuggestor ps = fac.getPropertySuggestor();
        NodeSet direct = ps.getCurrentDataProperties((OWLClassExpression)this.ca, true);
        Assert.assertTrue((boolean)direct.containsEntity((OWLObject)this.dx));
        Assert.assertEquals((long)1L, (long)direct.getNodes().size());
        NodeSet all = ps.getCurrentDataProperties((OWLClassExpression)this.ca, false);
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.dx));
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.df.getOWLTopDataProperty()));
        Assert.assertEquals((long)2L, (long)all.getNodes().size());
    }

    public void testCurrentObjectPropertiesSynonyms() throws Exception {
        OWLOntology ont = this.createOntology();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        SuggestorFactory fac = new SuggestorFactory(r);
        PropertySuggestor ps = fac.getPropertySuggestor();
        this.createEntities();
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ca, (OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.cb))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLEquivalentObjectPropertiesAxiom((OWLObjectPropertyExpression)this.op, (OWLObjectPropertyExpression)this.oq)));
        this.mngr.applyChanges(changes);
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.op, true));
        Assert.assertTrue((boolean)ps.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)this.oq, true));
        NodeSet direct = ps.getCurrentObjectProperties((OWLClassExpression)this.ca, true);
        Assert.assertTrue((boolean)direct.containsEntity((OWLObject)this.op));
        Assert.assertTrue((boolean)direct.containsEntity((OWLObject)this.oq));
        Assert.assertEquals((long)1L, (long)direct.getNodes().size());
        NodeSet all = ps.getCurrentObjectProperties((OWLClassExpression)this.ca, false);
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.op));
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.oq));
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.df.getOWLTopObjectProperty()));
        Assert.assertEquals((long)2L, (long)all.getNodes().size());
    }

    public void testGetPossibleObjectProperties() throws Exception {
        OWLOntology ont = this.createModelA();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        SuggestorFactory fac = new SuggestorFactory(r);
        PropertySuggestor ps = fac.getPropertySuggestor();
        NodeSet specific = ps.getPossibleObjectProperties((OWLClassExpression)this.ca, null, true);
        Assert.assertEquals((long)7L, (long)specific.getNodes().size());
        Assert.assertTrue((boolean)specific.containsEntity((OWLObject)this.op));
        Assert.assertTrue((boolean)specific.containsEntity((OWLObject)this.df.getOWLObjectInverseOf((OWLObjectPropertyExpression)this.op)));
        Assert.assertTrue((boolean)specific.containsEntity((OWLObject)this.or));
        Assert.assertTrue((boolean)specific.containsEntity((OWLObject)this.df.getOWLObjectInverseOf((OWLObjectPropertyExpression)this.or)));
        Assert.assertTrue((boolean)specific.containsEntity((OWLObject)this.ot));
        Assert.assertTrue((boolean)specific.containsEntity((OWLObject)this.df.getOWLObjectInverseOf((OWLObjectPropertyExpression)this.ot)));
        Assert.assertTrue((boolean)specific.containsEntity((OWLObject)this.df.getOWLObjectInverseOf((OWLObjectPropertyExpression)this.os)));
        NodeSet all = ps.getPossibleObjectProperties((OWLClassExpression)this.ca, null, false);
        Assert.assertEquals((long)9L, (long)all.getNodes().size());
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.op));
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.df.getOWLObjectInverseOf((OWLObjectPropertyExpression)this.op)));
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.oq));
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.df.getOWLObjectInverseOf((OWLObjectPropertyExpression)this.oq)));
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.or));
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.df.getOWLObjectInverseOf((OWLObjectPropertyExpression)this.or)));
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.df.getOWLObjectInverseOf((OWLObjectPropertyExpression)this.os)));
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.ot));
        Assert.assertTrue((boolean)all.containsEntity((OWLObject)this.df.getOWLObjectInverseOf((OWLObjectPropertyExpression)this.ot)));
    }

    public void testGetImpossibleObjectProperties() throws Exception {
        OWLOntology ont = this.createModelB();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        SuggestorFactory fac = new SuggestorFactory(r);
        PropertySuggestor ps = fac.getPropertySuggestor();
        NodeSet properties = ps.getPossibleObjectProperties((OWLClassExpression)this.ca, null, false);
        Assert.assertFalse((boolean)properties.containsEntity((OWLObject)this.os));
        Assert.assertFalse((boolean)properties.containsEntity((OWLObject)this.or));
    }

    public void testGettersAgainstBooleanMethods() throws Exception {
        OWLOntology ont = this.createModelA();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        SuggestorFactory fac = new SuggestorFactory(r);
        PropertySuggestor ps = fac.getPropertySuggestor();
        NodeSet direct = ps.getCurrentObjectProperties((OWLClassExpression)this.ca, true);
        for (Object p : ont.getObjectPropertiesInSignature()) {
            if (ps.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)p, true)) {
                Assert.assertTrue((boolean)direct.containsEntity((OWLObject)p));
                continue;
            }
            Assert.assertFalse((boolean)direct.containsEntity((OWLObject)p));
        }
        NodeSet indirect = ps.getCurrentObjectProperties((OWLClassExpression)this.ca, false);
        for (OWLObjectProperty p : ont.getObjectPropertiesInSignature()) {
            if (ps.isCurrent((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)p, false)) {
                Assert.assertTrue((boolean)indirect.containsEntity((OWLObject)p));
                continue;
            }
            Assert.assertFalse((boolean)indirect.containsEntity((OWLObject)p));
        }
        for (OWLObjectProperty p : ont.getObjectPropertiesInSignature()) {
            NodeSet posdirect = ps.getPossibleObjectProperties((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)p, true);
            for (Node q : r.getSubObjectProperties((OWLObjectPropertyExpression)p, true)) {
                OWLObjectPropertyExpression qRep = (OWLObjectPropertyExpression)q.getRepresentativeElement();
                if (ps.isPossible((OWLClassExpression)this.ca, qRep)) {
                    Assert.assertTrue((String)("Cannot find " + q + " in direct possible properties of " + p), (boolean)posdirect.containsEntity((OWLObject)qRep));
                    continue;
                }
                Assert.assertFalse((String)("Found " + q + " in direct possible properties of " + p), (boolean)posdirect.containsEntity((OWLObject)qRep));
            }
        }
        NodeSet posindirect = ps.getPossibleObjectProperties((OWLClassExpression)this.ca, null, false);
        for (OWLObjectProperty p : ont.getObjectPropertiesInSignature()) {
            if (ps.isPossible((OWLClassExpression)this.ca, (OWLObjectPropertyExpression)p)) {
                Assert.assertTrue((boolean)posindirect.containsEntity((OWLObject)p));
                continue;
            }
            Assert.assertFalse((boolean)posindirect.containsEntity((OWLObject)p));
        }
    }

    public void testAnnotationPropertySanctioning() throws Exception {
        OWLOntology ont = this.createOntology();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        SuggestorFactory fac = new SuggestorFactory(r);
        PropertySuggestor ps = fac.getPropertySuggestor();
        OWLAnnotationProperty annot = this.createAnnotationProperty("ap");
        OWLClass a = this.createClass("a");
        OWLObjectProperty p = this.createObjectProperty("p");
        OWLObjectProperty q = this.createObjectProperty("q");
        OWLObjectProperty rr = this.createObjectProperty("r");
        OWLDataProperty j = this.createDataProperty("j");
        OWLDataProperty k = this.createDataProperty("k");
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)a, (OWLClassExpression)this.df.getOWLThing())));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)a.getIRI(), this.df.getOWLAnnotation(annot, (OWLAnnotationValue)p.getIRI()))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)a.getIRI(), this.df.getOWLAnnotation(annot, (OWLAnnotationValue)this.df.getOWLLiteral(q.getIRI().toString())))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)a.getIRI(), this.df.getOWLAnnotation(annot, (OWLAnnotationValue)j.getIRI()))));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)p)));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)q)));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)rr)));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)j)));
        changes.add(new AddAxiom(ont, (OWLAxiom)this.df.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)k)));
        this.mngr.applyChanges(changes);
        ps.addSanctionRule((PropertySanctionRule)new SimpleAnnotationPropertySanctionRule(annot, true));
    }
}

