/*
 * Decompiled with CFR 0.152.
 */
package org.coode.suggestor.util;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLRestriction;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;

class RestrictionVisitor
extends OWLClassExpressionVisitorAdapter {
    protected final OWLReasoner r;
    protected final OWLPropertyExpression<?, ?> prop;
    protected final Set<OWLPropertyExpression<?, ?>> props;
    private final Class<? extends OWLRestriction<?, ?, ?>> type;
    final Set<OWLRestriction<?, ?, ?>> restrs = new HashSet();

    RestrictionVisitor(OWLReasoner r, OWLPropertyExpression<?, ?> prop, Class<? extends OWLRestriction<?, ?, ?>> type) {
        this.r = r;
        this.prop = prop;
        this.type = type;
        this.props = new HashSet();
        this.props.add(prop);
        if (prop instanceof OWLObjectProperty) {
            this.props.addAll(r.getSubObjectProperties((OWLObjectPropertyExpression)((OWLObjectProperty)prop), false).getFlattened());
        } else if (prop instanceof OWLDataProperty) {
            this.props.addAll(r.getSubDataProperties((OWLDataProperty)prop, false).getFlattened());
        }
    }

    private void handleRestriction(OWLRestriction<?, ?, ?> restr) {
        if ((this.type == null || this.type.isAssignableFrom(restr.getClass())) && (this.prop == null || restr.getProperty().equals(this.prop))) {
            this.restrs.add(restr);
        }
    }

    public void visit(OWLObjectIntersectionOf and) {
        for (OWLClassExpression desc : and.getOperands()) {
            desc.accept((OWLClassExpressionVisitor)this);
        }
    }

    public void visit(OWLDataAllValuesFrom restr) {
        this.handleRestriction((OWLRestriction<?, ?, ?>)restr);
    }

    public void visit(OWLDataSomeValuesFrom restr) {
        this.handleRestriction((OWLRestriction<?, ?, ?>)restr);
    }

    public void visit(OWLDataHasValue restr) {
        this.handleRestriction((OWLRestriction<?, ?, ?>)restr);
    }

    public void visit(OWLDataMinCardinality restr) {
        this.handleRestriction((OWLRestriction<?, ?, ?>)restr);
    }

    public void visit(OWLDataExactCardinality restr) {
        this.handleRestriction((OWLRestriction<?, ?, ?>)restr);
    }

    public void visit(OWLDataMaxCardinality restr) {
        this.handleRestriction((OWLRestriction<?, ?, ?>)restr);
    }

    public void visit(OWLObjectAllValuesFrom restr) {
        this.handleRestriction((OWLRestriction<?, ?, ?>)restr);
    }

    public void visit(OWLObjectSomeValuesFrom restr) {
        this.handleRestriction((OWLRestriction<?, ?, ?>)restr);
    }

    public void visit(OWLObjectHasValue desc) {
        this.handleRestriction((OWLRestriction<?, ?, ?>)desc);
    }

    public void visit(OWLObjectMinCardinality desc) {
        this.handleRestriction((OWLRestriction<?, ?, ?>)desc);
    }

    public void visit(OWLObjectExactCardinality desc) {
        this.handleRestriction((OWLRestriction<?, ?, ?>)desc);
    }

    public void visit(OWLObjectMaxCardinality desc) {
        this.handleRestriction((OWLRestriction<?, ?, ?>)desc);
    }

    public void visit(OWLObjectHasSelf desc) {
        this.handleRestriction((OWLRestriction<?, ?, ?>)desc);
    }
}

