/*
 * Decompiled with CFR 0.152.
 */
package org.coode.suggestor.util;

import java.util.HashSet;
import java.util.Set;
import org.coode.suggestor.util.RestrictionVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLRestriction;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class RestrictionAccumulator {
    protected final OWLReasoner r;

    public RestrictionAccumulator(OWLReasoner r) {
        this.r = r;
    }

    public Set<OWLRestriction<?, ?, ?>> getRestrictions(OWLClassExpression cls, OWLPropertyExpression<?, ?> prop) {
        return this.accummulateRestrictions(cls, prop, null);
    }

    public <T extends OWLRestriction<?, ?, ?>> Set<T> getRestrictions(OWLClassExpression cls, OWLPropertyExpression<?, ?> prop, Class<T> type) {
        HashSet results = new HashSet();
        for (OWLRestriction<?, ?, ?> restr : this.accummulateRestrictions(cls, prop, type)) {
            results.add(restr);
        }
        return results;
    }

    protected Set<OWLRestriction<?, ?, ?>> accummulateRestrictions(OWLClassExpression cls, OWLPropertyExpression<?, ?> prop, Class<? extends OWLRestriction<?, ?, ?>> type) {
        Set relevantClasses = this.r.getSuperClasses(cls, false).getFlattened();
        RestrictionVisitor v = this.getVisitor(prop, type);
        if (!cls.isAnonymous()) {
            relevantClasses.add(cls.asOWLClass());
        } else {
            cls.accept((OWLClassExpressionVisitor)v);
        }
        OWLOntology rootOnt = this.r.getRootOntology();
        Set onts = rootOnt.getImportsClosure();
        for (OWLClass ancestor : relevantClasses) {
            for (OWLOntology ont : onts) {
                for (OWLClassExpression restr : ancestor.getSuperClasses(ont)) {
                    restr.accept((OWLClassExpressionVisitor)v);
                }
                for (OWLClassExpression restr : ancestor.getEquivalentClasses(ont)) {
                    restr.accept((OWLClassExpressionVisitor)v);
                }
            }
        }
        return v.restrs;
    }

    protected RestrictionVisitor getVisitor(OWLPropertyExpression<?, ?> prop, Class<? extends OWLRestriction<?, ?, ?>> type) {
        return new RestrictionVisitor(this.r, prop, type);
    }
}

