/*
 * Decompiled with CFR 0.152.
 */
package org.coode.suggestor.util;

import org.coode.suggestor.util.FillerAccumulator;
import org.coode.suggestor.util.RestrictionVisitor;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLRestriction;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class DataFillerAccumulator
extends FillerAccumulator<OWLObject> {
    public DataFillerAccumulator(OWLReasoner r) {
        super(r);
    }

    @Override
    protected RestrictionVisitor getVisitor(OWLPropertyExpression<?, ?> prop, Class<? extends OWLRestriction<?, ?, ?>> type) {
        return new RestrictionVisitor(this.r, prop, type){

            @Override
            public void visit(OWLDataSomeValuesFrom desc) {
                super.visit(desc);
                if (this.props.contains(desc.getProperty())) {
                    DataFillerAccumulator.this.add(desc.getFiller());
                }
            }

            @Override
            public void visit(OWLDataMinCardinality desc) {
                OWLDataRange filler;
                super.visit(desc);
                if (desc.getCardinality() > 0 && this.props.contains(desc.getProperty()) && (filler = (OWLDataRange)desc.getFiller()) != null) {
                    DataFillerAccumulator.this.add(filler);
                }
            }

            @Override
            public void visit(OWLDataExactCardinality desc) {
                OWLDataRange filler;
                super.visit(desc);
                if (desc.getCardinality() > 0 && this.props.contains(desc.getProperty()) && (filler = (OWLDataRange)desc.getFiller()) != null) {
                    DataFillerAccumulator.this.add(filler);
                }
            }

            @Override
            public void visit(OWLDataHasValue desc) {
                super.visit(desc);
                if (this.props.contains(desc.getProperty())) {
                    DataFillerAccumulator.this.add(desc.getValue());
                }
            }
        };
    }
}

