/*
 * Decompiled with CFR 0.152.
 */
package org.coode.suggestor.knowledgeexplorationimpl;

import org.coode.suggestor.api.PropertySanctionRule;
import org.coode.suggestor.api.PropertySuggestor;
import org.coode.suggestor.impl.IRIMatcher;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class SimpleAnnotationPropertySanctionRule
implements PropertySanctionRule {
    private OWLReasoner r;
    private final OWLAnnotationProperty annotationProperty;
    private final boolean recursive;

    public SimpleAnnotationPropertySanctionRule(OWLAnnotationProperty annotationProperty, boolean recursive) {
        this.annotationProperty = annotationProperty;
        this.recursive = recursive;
    }

    @Override
    public void setSuggestor(PropertySuggestor ps) {
        this.r = ps.getReasoner();
    }

    @Override
    public boolean meetsSanction(OWLClassExpression c, OWLObjectPropertyExpression p) {
        return this.hasAnnotation(c, (OWLPropertyExpression<?, ?>)p);
    }

    @Override
    public boolean meetsSanction(OWLClassExpression c, OWLDataProperty p) {
        return this.hasAnnotation(c, (OWLPropertyExpression<?, ?>)p);
    }

    private boolean hasAnnotation(OWLClassExpression c, OWLPropertyExpression<?, ?> p) {
        if (!p.isAnonymous()) {
            if (!c.isAnonymous() && this.hasSanctionAnnotation(c.asOWLClass(), (OWLProperty)p)) {
                return true;
            }
            if (this.recursive) {
                for (OWLClass superCls : this.r.getSuperClasses(c, true).getFlattened()) {
                    if (!this.hasAnnotation((OWLClassExpression)superCls, p)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasSanctionAnnotation(OWLClass c, OWLProperty<?, ?> p) {
        IRIMatcher iriMatcher = new IRIMatcher(p.getIRI());
        for (OWLOntology ont : this.r.getRootOntology().getImportsClosure()) {
            for (OWLAnnotation annot : c.getAnnotations(ont, this.annotationProperty)) {
                if (!((Boolean)annot.getValue().accept((OWLAnnotationValueVisitorEx)iriMatcher)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }
}

