/*
 * Decompiled with CFR 0.152.
 */
package org.coode.suggestor.impl;

import java.util.HashSet;
import java.util.Set;
import org.coode.suggestor.impl.Matcher;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;

abstract class AbstractMatcher<R extends OWLPropertyRange, F extends R, P extends OWLPropertyExpression<R, P>>
implements Matcher<R, F, P> {
    @Override
    public final boolean isMatch(OWLClassExpression c, P p, R f, boolean direct) {
        if (!direct) {
            return this.isMatch(c, p, f);
        }
        if (!this.isMatch(c, p, f)) {
            return false;
        }
        NodeSet<F> directSubs = this.getDirectSubs(f);
        for (Node node : directSubs) {
            OWLPropertyRange representativeElement = (OWLPropertyRange)node.getRepresentativeElement();
            if (representativeElement == null) {
                System.out.println("FillerSuggestorImpl.AbstractMatcher.isMatch() " + f);
            }
            if (!this.isMatch(c, p, representativeElement)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final NodeSet<F> getLeaves(OWLClassExpression c, P p, R start, boolean direct) {
        HashSet<Node<F>> nodes = new HashSet<Node<F>>();
        if (this.isMatch(c, p, start)) {
            for (Node sub : this.getDirectSubs(start)) {
                nodes.addAll(this.getLeaves(c, p, (OWLPropertyRange)sub.getRepresentativeElement(), direct).getNodes());
            }
            if (!direct || nodes.isEmpty() && !start.isTopEntity()) {
                nodes.add(this.getEquivalents(start));
            }
        }
        return this.createNodeSet(nodes);
    }

    @Override
    public final NodeSet<F> getRoots(OWLClassExpression c, P p, R start, boolean direct) {
        HashSet<Node<F>> nodes = new HashSet<Node<F>>();
        for (Node sub : this.getDirectSubs(start)) {
            if (!this.isMatch(c, p, (OWLPropertyRange)sub.getRepresentativeElement())) continue;
            nodes.add(sub);
            if (direct) continue;
            nodes.addAll(this.getRoots(c, p, (OWLPropertyRange)sub.getRepresentativeElement(), direct).getNodes());
        }
        return this.createNodeSet(nodes);
    }

    protected abstract NodeSet<F> getDirectSubs(R var1);

    protected abstract Node<F> getEquivalents(R var1);

    protected abstract NodeSet<F> createNodeSet(Set<Node<F>> var1);
}

