/*
 * Decompiled with CFR 0.152.
 */
package org.coode.suggestor.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.coode.suggestor.test.AbstractSuggestorTest;
import org.coode.suggestor.util.ReasonerHelper;
import org.junit.Assert;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class RedundancyTests
extends AbstractSuggestorTest {
    public void testFilterClasses() throws Exception {
        OWLOntology ont = this.createOntology();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        OWLClass a1 = this.createClass("a1");
        OWLClass a2 = this.createClass("a2");
        OWLClass a3 = this.createClass("a3");
        OWLClass b1 = this.createClass("b1");
        OWLClass b2 = this.createClass("b2");
        this.mngr.applyChanges(Arrays.asList(new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)a2, (OWLClassExpression)a1)), new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)a3, (OWLClassExpression)a2)), new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)b2, (OWLClassExpression)b1))));
        ReasonerHelper helper = new ReasonerHelper(r);
        Random ran = new Random(2L);
        List<OWLClassExpression> data = Arrays.asList(a2, b2, a3, b1, a1);
        for (int i = 0; i < 25; ++i) {
            System.out.println(data);
            LinkedHashSet<OWLClassExpression> test = new LinkedHashSet<OWLClassExpression>(data);
            Set result = helper.filterClassExpressions(test);
            Assert.assertEquals(new HashSet<OWLClass>(Arrays.asList(a3, b2)), (Object)result);
            Collections.shuffle(data, ran);
        }
    }

    public void testFilters() throws Exception {
        OWLOntology ont = this.createOntology();
        OWLReasoner r = ((OWLReasonerFactory)Class.forName("uk.ac.manchester.cs.jfact.JFactFactory").newInstance()).createNonBufferingReasoner(ont);
        OWLObjectProperty q = this.createObjectProperty("q");
        OWLObjectProperty p = this.createObjectProperty("p");
        OWLClass a = this.createClass("a");
        OWLClass b = this.createClass("b");
        OWLObjectSomeValuesFrom pSomeA = this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)p, (OWLClassExpression)a);
        OWLObjectSomeValuesFrom qSomeA = this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)q, (OWLClassExpression)a);
        OWLObjectSomeValuesFrom pSomeB = this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)p, (OWLClassExpression)b);
        OWLObjectSomeValuesFrom qSomeB = this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)q, (OWLClassExpression)b);
        this.mngr.applyChange((OWLOntologyChange)new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)p, (OWLObjectPropertyExpression)q)));
        this.mngr.applyChange((OWLOntologyChange)new AddAxiom(ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)a, (OWLClassExpression)b)));
        if (r.getBufferingMode().equals((Object)BufferingMode.BUFFERING)) {
            r.flush();
        }
        HashSet<OWLObjectSomeValuesFrom> expressions = new HashSet<OWLObjectSomeValuesFrom>();
        expressions.add(pSomeA);
        expressions.add(qSomeA);
        expressions.add(pSomeB);
        expressions.add(qSomeB);
        ReasonerHelper helper = new ReasonerHelper(r);
        Set nonRedundantExpressions = helper.filterClassExpressions(expressions);
        Assert.assertEquals((long)1L, (long)nonRedundantExpressions.size());
        Assert.assertTrue((boolean)nonRedundantExpressions.contains(pSomeA));
    }
}

