/*
 * Decompiled with CFR 0.152.
 */
package org.coode.suggestor.test;

import org.junit.After;
import org.junit.Before;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public abstract class AbstractSuggestorTest {
    protected static final String HERMIT_FACTORY = "org.semanticweb.HermiT.Reasoner$ReasonerFactory";
    protected static final String FACTPLUSPLUS_FACTORY = "uk.ac.manchester.cs.factplusplus.owlapiv3.FaCTPlusPlusReasonerFactory";
    protected static final String JFACT_FACTORY = "uk.ac.manchester.cs.jfact.JFactFactory";
    protected static final String PELLET_FACTORY = "com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory";
    public static final String DEFAULT_REASONER_FACTORY = "uk.ac.manchester.cs.jfact.JFactFactory";
    private static final String BASE = "http://example.com#";
    protected OWLOntologyManager mngr;
    protected OWLDataFactory df;

    @Before
    public void setUp() throws Exception {
        this.mngr = OWLManager.createOWLOntologyManager();
        this.df = this.mngr.getOWLDataFactory();
    }

    protected OWLOntology createOntology() throws OWLOntologyCreationException {
        return this.mngr.createOntology();
    }

    @After
    public void tearDown() {
        this.mngr = null;
        this.df = null;
    }

    protected OWLObjectProperty createObjectProperty(String name) {
        return this.df.getOWLObjectProperty(IRI.create((String)(BASE + name)));
    }

    protected OWLDataProperty createDataProperty(String name) {
        return this.df.getOWLDataProperty(IRI.create((String)(BASE + name)));
    }

    protected OWLClass createClass(String name) {
        return this.df.getOWLClass(IRI.create((String)(BASE + name)));
    }

    protected OWLAnnotationProperty createAnnotationProperty(String name) {
        return this.df.getOWLAnnotationProperty(IRI.create((String)(BASE + name)));
    }
}

