/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.HasAnonymousIndividuals;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNaryBooleanClassExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLAnonymousClassExpressionImpl;

public abstract class OWLNaryBooleanClassExpressionImpl
extends OWLAnonymousClassExpressionImpl
implements OWLNaryBooleanClassExpression {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final Set<OWLClassExpression> operands;

    public OWLNaryBooleanClassExpressionImpl(@Nonnull Set<? extends OWLClassExpression> operands) {
        this.operands = new TreeSet<OWLClassExpression>((Collection)OWLAPIPreconditions.checkNotNull(operands, (String)"operands cannot be null"));
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        for (OWLClassExpression operand : this.operands) {
            this.addSignatureEntitiesToSetForValue(entities, (HasSignature)operand);
        }
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        for (OWLClassExpression operand : this.operands) {
            this.addAnonymousIndividualsToSetForValue(anons, (HasAnonymousIndividuals)operand);
        }
    }

    public List<OWLClassExpression> getOperandsAsList() {
        return new ArrayList<OWLClassExpression>(this.operands);
    }

    public Set<OWLClassExpression> getOperands() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.operands);
    }

    public boolean isClassExpressionLiteral() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OWLNaryBooleanClassExpression)) {
            return false;
        }
        return ((OWLNaryBooleanClassExpression)obj).getOperands().equals(this.operands);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        return OWLNaryBooleanClassExpressionImpl.compareSets(this.operands, ((OWLNaryBooleanClassExpression)object).getOperands());
    }
}

