/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;

public abstract class DefaultNode<E extends OWLObject>
implements Node<E> {
    private static final OWLDataFactory DF = new OWLDataFactoryImpl(false, false);
    @Nonnull
    protected static final OWLClass TOP_CLASS = DF.getOWLThing();
    @Nonnull
    protected static final OWLClassNode TOP_NODE = new OWLClassNode(TOP_CLASS);
    @Nonnull
    protected static final OWLClass BOTTOM_CLASS = DF.getOWLNothing();
    @Nonnull
    protected static final OWLClassNode BOTTOM_NODE = new OWLClassNode(BOTTOM_CLASS);
    @Nonnull
    protected static final OWLDataProperty TOP_DATA_PROPERTY = DF.getOWLTopDataProperty();
    @Nonnull
    protected static final OWLDataPropertyNode TOP_DATA_NODE = new OWLDataPropertyNode(TOP_DATA_PROPERTY);
    @Nonnull
    protected static final OWLDataProperty BOTTOM_DATA_PROPERTY = DF.getOWLBottomDataProperty();
    @Nonnull
    protected static final OWLDataPropertyNode BOTTOM_DATA_NODE = new OWLDataPropertyNode(BOTTOM_DATA_PROPERTY);
    @Nonnull
    protected static final OWLDatatype TOP_DATATYPE = DF.getTopDatatype();
    @Nonnull
    protected static final OWLObjectProperty TOP_OBJECT_PROPERTY = DF.getOWLTopObjectProperty();
    @Nonnull
    protected static final OWLObjectPropertyNode TOP_OBJECT_NODE = new OWLObjectPropertyNode((OWLObjectPropertyExpression)TOP_OBJECT_PROPERTY);
    @Nonnull
    protected static final OWLObjectProperty BOTTOM_OBJECT_PROPERTY = DF.getOWLBottomObjectProperty();
    @Nonnull
    protected static final OWLObjectPropertyNode BOTTOM_OBJECT_NODE = new OWLObjectPropertyNode((OWLObjectPropertyExpression)BOTTOM_OBJECT_PROPERTY);
    @Nonnull
    private final Set<E> entities = new HashSet(4);

    public DefaultNode(@Nonnull E entity) {
        this.entities.add(OWLAPIPreconditions.checkNotNull(entity, (String)"entity cannot be null"));
    }

    public DefaultNode(@Nonnull Set<E> entities) {
        this.entities.addAll((Collection)OWLAPIPreconditions.checkNotNull(entities, (String)"entities cannot be null"));
    }

    protected DefaultNode() {
    }

    protected abstract E getTopEntity();

    protected abstract E getBottomEntity();

    public void add(E entity) {
        this.entities.add(entity);
    }

    public boolean isTopNode() {
        return this.entities.contains(this.getTopEntity());
    }

    public boolean isBottomNode() {
        return this.entities.contains(this.getBottomEntity());
    }

    @Nonnull
    public Set<E> getEntities() {
        return this.entities;
    }

    public int getSize() {
        return this.entities.size();
    }

    public boolean contains(E entity) {
        return this.entities.contains(entity);
    }

    @Nonnull
    public Set<E> getEntitiesMinus(E e) {
        HashSet<E> result = new HashSet<E>(this.entities);
        result.remove(e);
        return result;
    }

    @Nonnull
    public Set<E> getEntitiesMinusTop() {
        return this.getEntitiesMinus(this.getTopEntity());
    }

    @Nonnull
    public Set<E> getEntitiesMinusBottom() {
        return this.getEntitiesMinus(this.getBottomEntity());
    }

    public boolean isSingleton() {
        return this.entities.size() == 1;
    }

    @Nonnull
    public E getRepresentativeElement() {
        return (E)((OWLObject)this.entities.iterator().next());
    }

    @Nonnull
    public Iterator<E> iterator() {
        return this.entities.iterator();
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node( ");
        for (OWLObject entity : this.entities) {
            sb.append(entity);
            sb.append(' ');
        }
        sb.append(')');
        return (String)OWLAPIPreconditions.verifyNotNull((Object)sb.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        return this.entities.equals(other.getEntities());
    }

    public int hashCode() {
        return this.entities.hashCode();
    }
}

