/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation.io;

import com.clarkparsia.owlapi.explanation.io.ExplanationRenderer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.SimpleRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConciseExplanationRenderer
implements ExplanationRenderer {
    private static final String INDENT = "   ";
    private final SimpleRenderer renderer = new SimpleRenderer();
    private PrintWriter writer;

    @Override
    public void startRendering(Writer w) {
        this.writer = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
    }

    @Override
    public void render(OWLAxiom axiom, Set<Set<OWLAxiom>> explanations) throws OWLException, IOException {
        this.writer.println("Axiom: " + this.renderer.render((OWLObject)axiom));
        int expSize = explanations.size();
        if (expSize == 0) {
            this.writer.println("Explanation: AXIOM IS NOT ENTAILED!");
            return;
        }
        if (expSize == 1) {
            this.writer.println("Explanation: ");
            Set<OWLAxiom> explanation = explanations.iterator().next();
            this.renderSingleExplanation(INDENT, explanation);
        } else {
            this.writer.println("Explanations (" + expSize + "): ");
            this.renderMultipleExplanations(explanations);
        }
        this.writer.println();
    }

    private void renderMultipleExplanations(Set<Set<OWLAxiom>> explanations) throws OWLException, IOException {
        int count = 1;
        for (Set<OWLAxiom> exp : explanations) {
            String header = count++ + ") ";
            this.renderSingleExplanation(header, exp);
        }
    }

    private void renderSingleExplanation(String header, Set<OWLAxiom> axioms) throws OWLException, IOException {
        boolean first = true;
        for (OWLAxiom axiom : axioms) {
            if (first) {
                first = false;
            } else {
                header = INDENT;
            }
            this.writer.println(header + this.renderer.render((OWLObject)axiom));
        }
    }

    @Override
    public void endRendering() {
        this.writer.flush();
    }
}

