/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public class SatisfiabilityConverter {
    private static final Logger logger = Logger.getLogger(SatisfiabilityConverter.class.getName());
    private final AxiomConverter converter;
    protected final OWLDataFactory factory;

    public SatisfiabilityConverter(OWLDataFactory factory) {
        this.factory = factory;
        this.converter = new AxiomConverter();
    }

    public OWLClassExpression convert(OWLAxiom axiom) {
        this.converter.reset();
        axiom.accept((OWLAxiomVisitor)this.converter);
        OWLClassExpression result = this.converter.getResult();
        if (result == null) {
            throw new RuntimeException("Not supported yet");
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AxiomConverter
    implements OWLAxiomVisitor {
        private OWLClassExpression result;

        private AxiomConverter() {
        }

        private OWLObjectIntersectionOf and(OWLClassExpression desc1, OWLClassExpression desc2) {
            return SatisfiabilityConverter.this.factory.getOWLObjectIntersectionOf(this.set(desc1, desc2));
        }

        private OWLObjectIntersectionOf and(Set<OWLClassExpression> set) {
            return SatisfiabilityConverter.this.factory.getOWLObjectIntersectionOf(set);
        }

        OWLClassExpression getResult() {
            return this.result;
        }

        private OWLObjectComplementOf not(OWLClassExpression desc) {
            return SatisfiabilityConverter.this.factory.getOWLObjectComplementOf(desc);
        }

        private OWLObjectOneOf oneOf(OWLIndividual ind) {
            return SatisfiabilityConverter.this.factory.getOWLObjectOneOf(Collections.singleton(ind));
        }

        private OWLObjectUnionOf or(OWLClassExpression desc1, OWLClassExpression desc2) {
            return SatisfiabilityConverter.this.factory.getOWLObjectUnionOf(this.set(desc1, desc2));
        }

        void reset() {
            this.result = null;
        }

        private <T> Set<T> set(T desc1, T desc2) {
            HashSet<T> set = new HashSet<T>();
            set.add(desc1);
            set.add(desc2);
            return set;
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            OWLIndividual ind = axiom.getIndividual();
            OWLClassExpression c = axiom.getClassExpression();
            this.result = this.and((OWLClassExpression)this.oneOf(ind), (OWLClassExpression)this.not(c));
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            OWLObjectOneOf sub = this.oneOf(axiom.getSubject());
            OWLDataHasValue sup = SatisfiabilityConverter.this.factory.getOWLDataHasValue((OWLDataPropertyExpression)axiom.getProperty(), (OWLLiteral)axiom.getObject());
            OWLSubClassOfAxiom ax = SatisfiabilityConverter.this.factory.getOWLSubClassOfAxiom((OWLClassExpression)sub, (OWLClassExpression)sup);
            ax.accept((OWLAxiomVisitor)this);
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            OWLDataSomeValuesFrom sub = SatisfiabilityConverter.this.factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), (OWLDataRange)SatisfiabilityConverter.this.factory.getTopDatatype());
            this.result = this.and((OWLClassExpression)sub, (OWLClassExpression)this.not(axiom.getDomain()));
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            this.result = SatisfiabilityConverter.this.factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), (OWLDataRange)SatisfiabilityConverter.this.factory.getOWLDataComplementOf((OWLDataRange)axiom.getRange()));
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLDeclarationAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            HashSet<OWLObjectOneOf> nominals = new HashSet<OWLObjectOneOf>();
            for (OWLIndividual ind : axiom.getIndividuals()) {
                nominals.add(this.oneOf(ind));
            }
            this.result = SatisfiabilityConverter.this.factory.getOWLObjectIntersectionOf(nominals);
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            this.result = this.and(axiom.getClassExpressions());
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            Iterator classes = axiom.getClassExpressions().iterator();
            OWLClassExpression c1 = (OWLClassExpression)classes.next();
            OWLClassExpression c2 = (OWLClassExpression)classes.next();
            if (classes.hasNext()) {
                logger.warning("EquivalentClassesAxiom with more than two elements not supported!");
            }
            this.result = c1.isOWLNothing() ? c2 : (c2.isOWLNothing() ? c1 : (c1.isOWLThing() ? this.not(c2) : (c2.isOWLThing() ? this.not(c1) : this.or((OWLClassExpression)this.and(c1, (OWLClassExpression)this.not(c2)), (OWLClassExpression)this.and((OWLClassExpression)this.not(c1), c2)))));
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            OWLObjectOneOf sub = this.oneOf(axiom.getSubject());
            OWLDataHasValue sup = SatisfiabilityConverter.this.factory.getOWLDataHasValue((OWLDataPropertyExpression)axiom.getProperty(), (OWLLiteral)axiom.getObject());
            SatisfiabilityConverter.this.factory.getOWLSubClassOfAxiom((OWLClassExpression)sub, (OWLClassExpression)this.not((OWLClassExpression)sup)).accept((OWLAxiomVisitor)this);
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            OWLObjectOneOf sub = this.oneOf(axiom.getSubject());
            OWLObjectHasValue sup = SatisfiabilityConverter.this.factory.getOWLObjectHasValue((OWLObjectPropertyExpression)axiom.getProperty(), (OWLIndividual)axiom.getObject());
            SatisfiabilityConverter.this.factory.getOWLSubClassOfAxiom((OWLClassExpression)sub, (OWLClassExpression)this.not((OWLClassExpression)sup)).accept((OWLAxiomVisitor)this);
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            OWLObjectOneOf sub = this.oneOf(axiom.getSubject());
            OWLObjectHasValue sup = SatisfiabilityConverter.this.factory.getOWLObjectHasValue((OWLObjectPropertyExpression)axiom.getProperty(), (OWLIndividual)axiom.getObject());
            OWLSubClassOfAxiom ax = SatisfiabilityConverter.this.factory.getOWLSubClassOfAxiom((OWLClassExpression)sub, (OWLClassExpression)sup);
            ax.accept((OWLAxiomVisitor)this);
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            this.result = this.and((OWLClassExpression)SatisfiabilityConverter.this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)SatisfiabilityConverter.this.factory.getOWLThing()), (OWLClassExpression)this.not(axiom.getDomain()));
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            this.result = SatisfiabilityConverter.this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)this.not((OWLClassExpression)axiom.getRange()));
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLSameIndividualAxiom axiom) {
            HashSet<OWLClassExpression> nominals = new HashSet<OWLClassExpression>();
            for (OWLIndividual ind : axiom.getIndividuals()) {
                nominals.add((OWLClassExpression)this.not((OWLClassExpression)this.oneOf(ind)));
            }
            this.result = this.and(nominals);
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            OWLClassExpression sub = axiom.getSubClass();
            OWLClassExpression sup = axiom.getSuperClass();
            this.result = sup.isOWLNothing() ? sub : (sub.isOWLThing() ? this.not(sup) : this.and(sub, (OWLClassExpression)this.not(sup)));
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(SWRLRule rule) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + rule);
        }

        public void visit(OWLHasKeyAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }

        public void visit(OWLDatatypeDefinitionAxiom axiom) {
            throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + axiom);
        }
    }
}

