/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.CachingBidirectionalShortFormProvider;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class BidirectionalShortFormProviderAdapter
extends CachingBidirectionalShortFormProvider {
    @Nullable
    protected final Collection<OWLOntology> ontologies;
    private final ShortFormProvider shortFormProvider;
    @Nullable
    private OWLOntologyManager man;

    public BidirectionalShortFormProviderAdapter(ShortFormProvider shortFormProvider) {
        this.shortFormProvider = OWLAPIPreconditions.checkNotNull(shortFormProvider, "shortFormProvider cannot be null");
        this.ontologies = null;
    }

    public BidirectionalShortFormProviderAdapter(Collection<OWLOntology> ontologies, ShortFormProvider shortFormProvider) {
        this.shortFormProvider = OWLAPIPreconditions.checkNotNull(shortFormProvider, "shortFormProvider cannot be null");
        this.ontologies = OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
        this.rebuild(ontologies.stream().flatMap(HasSignature::unsortedSignature));
    }

    public BidirectionalShortFormProviderAdapter(OWLOntologyManager man, Collection<OWLOntology> ontologies, ShortFormProvider shortFormProvider) {
        this(ontologies, shortFormProvider);
        this.man = OWLAPIPreconditions.checkNotNull(man, "man cannot be null");
        this.man.addOntologyChangeListener(this::handleChanges);
    }

    @Override
    protected String generateShortForm(OWLEntity entity) {
        return this.shortFormProvider.getShortForm(entity);
    }

    @Override
    public void dispose() {
        if (this.man != null) {
            this.man.removeOntologyChangeListener(this::handleChanges);
        }
    }

    void handleChanges(List<? extends OWLOntologyChange> changes) {
        if (this.ontologies == null) {
            return;
        }
        final HashSet processed = new HashSet();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            assert (this.ontologies != null);
            if (!this.ontologies.contains(oWLOntologyChange.getOntology())) continue;
            OWLOntologyChangeVisitor v = new OWLOntologyChangeVisitor(){

                @Override
                public void visit(AddAxiom change) {
                    change.signature().filter(processed::add).forEach(BidirectionalShortFormProviderAdapter.this::add);
                }

                @Override
                public void visit(RemoveAxiom change) {
                    change.signature().filter(processed::add).filter(BidirectionalShortFormProviderAdapter.this::noLongerReferenced).forEach(BidirectionalShortFormProviderAdapter.this::remove);
                }
            };
            oWLOntologyChange.accept(v);
        }
    }

    protected boolean noLongerReferenced(OWLEntity ent) {
        if (this.ontologies == null) {
            return true;
        }
        assert (this.ontologies != null);
        return this.ontologies.stream().noneMatch(ont -> ont.containsEntityInSignature(ent));
    }
}

