/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.semanticweb.owlapi.model.OWLOntologyFormat;

public enum Extensions {
    RDFXML("org.semanticweb.owlapi.model.OWLOntologyFormat", ".owl", ".rdf", ".rdfs"),
    OWLXML("org.semanticweb.owlapi.io.OWLXMLOntologyFormat", ".xml"),
    TURTLE("org.coode.owlapi.turtle.TurtleOntologyFormat", ".ttl"),
    OBO("org.coode.owlapi.obo.parser.OBOOntologyFormat", ".obo"),
    MANCHESTERSYNTAX("org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxOntologyFormat", ".omn"),
    FUNCTIONALSYNTAX("org.semanticweb.owlapi.io.OWLFunctionalSyntaxOntologyFormat", ".fss");

    private List<String> extensions;
    private String documentFormat;

    private Extensions(String d, String ... knownExtensions) {
        this.documentFormat = d;
        this.extensions = Arrays.asList(knownExtensions);
    }

    public Collection<String> getCommonExtensions() {
        return this.extensions;
    }

    public static Collection<String> getCommonExtensions(Class<? extends OWLOntologyFormat> format) {
        if (format == null) {
            return Collections.emptyList();
        }
        for (Extensions e : Extensions.values()) {
            if (!e.documentFormat.equals(format.getCanonicalName())) continue;
            return e.getCommonExtensions();
        }
        return Collections.emptyList();
    }

    public static Collection<String> getCommonExtensions(OWLOntologyFormat format) {
        if (format == null) {
            return Collections.emptyList();
        }
        if (format.getCommonExtensions().isEmpty()) {
            return Extensions.getCommonExtensions(format.getClass());
        }
        return format.getCommonExtensions();
    }
}

